/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

final class HeaderAnnotator
implements Annotator {
    HeaderAnnotator() {
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement instanceof Header) {
            Header header = (Header)psiElement;
            String name2 = header.getName();
            if (!HeaderAnnotator.isValidName(name2)) {
                holder.newAnnotation(HighlightSeverity.ERROR, ManifestBundle.message("header.name.invalid", new Object[0])).range((PsiElement)header.getNameElement()).create();
            } else {
                HeaderParser headerParser = HeaderParserRepository.getInstance().getHeaderParser(name2);
                if (headerParser != null) {
                    headerParser.annotate(header, holder);
                }
            }
        }
    }

    private static boolean isValidName(String name2) {
        for (int i = 0; i < name2.length(); ++i) {
            char c = name2.charAt(i);
            if (c == '-' || c == '_' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }
}

