/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeParallelIfsPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeParallelIfsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new MergeParallelIfsPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token = (PsiJavaToken)element;
        PsiIfStatement firstStatement = (PsiIfStatement)token.getParent();
        PsiIfStatement secondStatement = (PsiIfStatement)PsiTreeUtil.skipWhitespacesForward((PsiElement)firstStatement);
        assert (secondStatement != null);
        CommentTracker tracker = new CommentTracker();
        String newStatementText = MergeParallelIfsIntention.mergeIfStatements(firstStatement, secondStatement, tracker);
        PsiReplacementUtil.replaceStatement((PsiStatement)firstStatement, newStatementText, tracker);
        secondStatement.delete();
    }

    private static String mergeIfStatements(PsiIfStatement firstStatement, PsiIfStatement secondStatement, CommentTracker tracker) {
        PsiExpression condition2 = firstStatement.getCondition();
        String conditionText = condition2 == null ? "" : tracker.text((PsiElement)condition2);
        PsiStatement firstThenBranch = firstStatement.getThenBranch();
        PsiStatement secondThenBranch = secondStatement.getThenBranch();
        String statement = "if(" + conditionText + ')' + MergeParallelIfsIntention.printStatementsInSequence(firstThenBranch, secondThenBranch, tracker);
        PsiStatement firstElseBranch = firstStatement.getElseBranch();
        PsiStatement secondElseBranch = secondStatement.getElseBranch();
        if (firstElseBranch != null || secondElseBranch != null) {
            statement = firstElseBranch instanceof PsiIfStatement && secondElseBranch instanceof PsiIfStatement && MergeParallelIfsPredicate.ifStatementsCanBeMerged((PsiIfStatement)firstElseBranch, (PsiIfStatement)secondElseBranch) ? statement + "else " + MergeParallelIfsIntention.mergeIfStatements((PsiIfStatement)firstElseBranch, (PsiIfStatement)secondElseBranch, tracker) : statement + "else" + MergeParallelIfsIntention.printStatementsInSequence(firstElseBranch, secondElseBranch, tracker);
        }
        return statement;
    }

    private static String printStatementsInSequence(PsiStatement statement1, PsiStatement statement2, CommentTracker tracker) {
        if (statement1 == null) {
            return ' ' + tracker.text((PsiElement)statement2);
        }
        if (statement2 == null) {
            return ' ' + tracker.text((PsiElement)statement1);
        }
        StringBuilder out = new StringBuilder("{");
        MergeParallelIfsIntention.printStatementStripped(statement1, tracker, out);
        MergeParallelIfsIntention.printStatementStripped(statement2, tracker, out);
        out.append('}');
        return out.toString();
    }

    private static void printStatementStripped(PsiStatement statement, CommentTracker tracker, StringBuilder out) {
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)statement).getCodeBlock();
            PsiElement[] children = block.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                out.append(tracker.text(children[i]));
            }
        } else {
            out.append(tracker.text((PsiElement)statement));
        }
    }
}

