/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.CreateAssertPredicate;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateAssertIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new CreateAssertPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        String newStatement;
        PsiExpressionStatement statement = (PsiExpressionStatement)element;
        PsiExpression expression2 = statement.getExpression();
        if (BoolUtils.isNegation(expression2)) {
            newStatement = CreateAssertIntention.buildNewStatement("assertFalse", element, BoolUtils.getNegatedExpressionText(expression2));
        } else if (ComparisonUtils.isNullComparison(expression2)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            PsiExpression comparedExpression = ExpressionUtils.getValueComparedWithNull(binaryExpression);
            assert (comparedExpression != null);
            newStatement = JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) ? CreateAssertIntention.buildNewStatement("assertNull", element, comparedExpression.getText()) : CreateAssertIntention.buildNewStatement("assertNotNull", element, comparedExpression.getText());
        } else if (CreateAssertIntention.isEqualityComparison(expression2)) {
            PsiExpression comparingExpression;
            PsiExpression comparedExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs instanceof PsiLiteralExpression) {
                comparedExpression = rhs;
                comparingExpression = lhs;
            } else {
                comparedExpression = lhs;
                comparingExpression = rhs;
            }
            assert (comparingExpression != null);
            PsiType type2 = lhs.getType();
            newStatement = PsiType.DOUBLE.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText(), "0.0") : (type2 instanceof PsiPrimitiveType ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText()) : CreateAssertIntention.buildNewStatement("assertSame", element, comparedExpression.getText(), comparingExpression.getText()));
        } else if (CreateAssertIntention.isEqualsExpression(expression2)) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression comparedExpression = methodExpression.getQualifierExpression();
            assert (comparedExpression != null);
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression comparingExpression = argList.getExpressions()[0];
            newStatement = comparingExpression instanceof PsiLiteralExpression ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparingExpression.getText(), comparedExpression.getText()) : CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText());
        } else {
            newStatement = CreateAssertIntention.buildNewStatement("assertTrue", element, expression2.getText());
        }
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newStatement);
    }

    @NonNls
    private static String buildNewStatement(@NonNls String memberName, PsiElement context, String ... argumentTexts) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        StringBuilder builder = new StringBuilder(memberName).append('(');
        boolean comma = false;
        for (String argumentText : argumentTexts) {
            if (comma) {
                builder.append(',');
            } else {
                comma = true;
            }
            builder.append(argumentText);
        }
        builder.append(')');
        String text2 = builder.toString();
        String qualifier = CreateAssertIntention.isJUnit5(context) ? "org.junit.jupiter.api.Assertions" : "org.junit.Assert";
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(text2, context);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (CreateAssertIntention.isJUnitMethod(method) || CreateAssertIntention.hasStaticImports(context) && ImportUtils.addStaticImport(qualifier, memberName, context)) {
            return text2 + ';';
        }
        return qualifier + '.' + text2 + ';';
    }

    private static boolean isJUnit5(PsiElement context) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        Set frameworks = TestFrameworks.detectApplicableFrameworks((PsiClass)aClass);
        return frameworks.stream().anyMatch(framework -> framework.getName().equals("JUnit5") && framework.isTestMethod((PsiElement)method, false));
    }

    private static boolean isJUnitMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName);
    }

    private static boolean hasStaticImports(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        return importList != null && importList.getImportStaticStatements().length > 0;
    }

    private static boolean isEqualsExpression(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"equals".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] expressions2 = argList.getExpressions();
        return expressions2.length == 1 && expressions2[0] != null;
    }

    private static boolean isEqualityComparison(PsiExpression expression2) {
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        return JavaTokenType.EQEQ.equals(tokenType);
    }
}

