/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression.eliminate;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.expression.eliminate.AssociativeExpression;
import com.siyeh.ipp.expression.eliminate.DistributiveExpression;
import com.siyeh.ipp.expression.eliminate.EliminableExpression;
import com.siyeh.ipp.expression.eliminate.EliminateUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EliminateParenthesesIntention
extends BaseElementAtCaretIntentionAction {
    private static final Pass<PsiParenthesizedExpression> ELIMINATE_CALLBACK = new Pass<PsiParenthesizedExpression>(){

        public void pass(@NotNull PsiParenthesizedExpression expression2) {
            WriteCommandAction.writeCommandAction((Project)expression2.getProject(), (PsiFile[])new PsiFile[]{expression2.getContainingFile()}).withName(EliminateParenthesesIntention.getName()).run(() -> EliminateParenthesesIntention.replaceExpression(expression2));
        }
    };

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return EliminateParenthesesIntention.getName();
    }

    @NotNull
    public String getText() {
        return EliminateParenthesesIntention.getName();
    }

    private static String getName() {
        return IntentionPowerPackBundle.defaultableMessage("eliminate.parentheses.intention.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        List<PsiParenthesizedExpression> possibleInnerExpressions = EliminateParenthesesIntention.getPossibleInnerExpressions(element);
        return possibleInnerExpressions != null && !possibleInnerExpressions.isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        List<PsiParenthesizedExpression> possibleInnerExpressions = EliminateParenthesesIntention.getPossibleInnerExpressions(element);
        if (possibleInnerExpressions == null) {
            return;
        }
        EliminateParenthesesIntention.processInnerExpression(editor, possibleInnerExpressions);
    }

    private static void processInnerExpression(@Nullable Editor editor, @NotNull List<PsiParenthesizedExpression> expressions2) {
        if (expressions2.size() == 1) {
            EliminateParenthesesIntention.replaceExpression(expressions2.get(0));
            return;
        }
        if (expressions2.isEmpty() || editor == null) {
            return;
        }
        IntroduceTargetChooser.showChooser((Editor)editor, expressions2, ELIMINATE_CALLBACK, (Function)new PsiExpressionTrimRenderer.RenderFunction());
    }

    private static void replaceExpression(@NotNull PsiParenthesizedExpression parenthesized) {
        EliminableExpression expression2 = EliminateParenthesesIntention.createEliminableExpression(parenthesized);
        if (expression2 == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        CommentTracker commentTracker = new CommentTracker();
        PsiExpression toReplace = expression2.getExpressionToReplace();
        PsiPolyadicExpression outerExpression = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)toReplace.getParent(), PsiPolyadicExpression.class);
        if (outerExpression == null || EliminateUtils.getOperator(outerExpression.getOperationTokenType()) == null) {
            if (!expression2.eliminate(null, sb)) {
                return;
            }
            PsiReplacementUtil.replaceExpression(toReplace, sb.toString(), commentTracker);
            return;
        }
        for (PsiExpression operand2 : outerExpression.getOperands()) {
            PsiJavaToken tokenBefore = outerExpression.getTokenBeforeOperand(operand2);
            if (operand2 == toReplace) {
                if (expression2.eliminate(tokenBefore, sb)) continue;
                return;
            }
            if (tokenBefore != null) {
                sb.append(tokenBefore.getText());
            }
            sb.append(operand2.getText());
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)outerExpression, sb.toString(), commentTracker);
    }

    @Nullable
    private static EliminableExpression createEliminableExpression(@NotNull PsiParenthesizedExpression parenthesized) {
        DistributiveExpression distributive = DistributiveExpression.create(parenthesized);
        AssociativeExpression additive = AssociativeExpression.create(parenthesized);
        if (distributive == null) {
            return additive;
        }
        if (additive == null) {
            return distributive;
        }
        if (distributive.getExpression() == null) {
            return additive;
        }
        return distributive;
    }

    @Nullable
    private static List<PsiParenthesizedExpression> getPossibleInnerExpressions(@NotNull PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        ArrayList<PsiParenthesizedExpression> possibleExpressions = new ArrayList<PsiParenthesizedExpression>();
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiParenthesizedExpression.class)) != null) {
            PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)element;
            if (DistributiveExpression.create(parenthesized) == null && AssociativeExpression.create(parenthesized) == null) continue;
            possibleExpressions.add(parenthesized);
        }
        return possibleExpressions;
    }
}

