/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.collections;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ObjectUtils;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.collections.ImmutableCollectionModelUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithMutableCollectionIntention
extends Intention {
    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        ImmutableCollectionModelUtils.ImmutableCollectionModel model = ImmutableCollectionModelUtils.createModel(call);
        if (model == null) {
            return;
        }
        ImmutableCollectionModelUtils.replaceWithMutable(model, editor);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        this.processIntention(null, element);
    }

    @Override
    @NotNull
    public String getText() {
        return IntentionPowerPackBundle.defaultableMessage("replace.with.mutable.collection.intention.family.name", new Object[0]);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return element -> {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class);
            return call != null && ImmutableCollectionModelUtils.createModel(call) != null;
        };
    }
}

