/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class AwaitNotInLoopInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("await.not.in.loop.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AwaitNotInLoopVisitor();
    }

    private static class AwaitNotInLoopVisitor
    extends BaseInspectionVisitor {
        private AwaitNotInLoopVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, "java.util.concurrent.locks.Condition", (PsiType)PsiType.VOID, "await", new PsiType[0])) {
                return;
            }
            if (ControlFlowUtils.isInLoop((PsiElement)expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

