/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ObjectsEqualsCanBeSimplifiedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OBJECTS_EQUALS = CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!OBJECTS_EQUALS.test(call)) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                PsiExpression arg1 = args[0];
                PsiExpression arg2 = args[1];
                PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                if (this.processPrimitives(nameElement, arg1, arg2)) {
                    return;
                }
                PsiClass argClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)arg1.getType());
                if (argClass == null) {
                    return;
                }
                if (NullabilityUtil.getExpressionNullability(arg1, true) == Nullability.NOT_NULL) {
                    PsiMethod[] equalsMethods;
                    for (PsiMethod method : equalsMethods = argClass.findMethodsByName("equals", true)) {
                        if (method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != 1 || TypeUtils.isJavaLangObject(Objects.requireNonNull(method.getParameterList().getParameter(0)).getType())) continue;
                        return;
                    }
                    holder.registerProblem(nameElement, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"equals()"}), new LocalQuickFix[]{new ReplaceWithEqualsFix(false)});
                }
            }

            private boolean processPrimitives(PsiElement nameElement, PsiExpression arg1, PsiExpression arg2) {
                PsiType type1 = arg1.getType();
                PsiType type2 = arg2.getType();
                if (type1 instanceof PsiPrimitiveType && type1.equals(type2) && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type1)) {
                    holder.registerProblem(nameElement, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"=="}), new LocalQuickFix[]{new ReplaceWithEqualsFix(true)});
                    return true;
                }
                return false;
            }
        };
    }

    private static class ReplaceWithEqualsFix
    implements LocalQuickFix {
        final boolean myEquality;

        private ReplaceWithEqualsFix(boolean equality) {
            this.myEquality = equality;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"Objects.equals()", this.myEquality ? "==" : "equals()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 2) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = this.myEquality ? ct.text(args[0], 9) + "==" + ct.text(args[1], 9) : ct.text(args[0], 1) + ".equals(" + ct.text((PsiElement)args[1]) + ")";
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }
    }
}

