/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.canBeFinal.CanBeFinalHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.reference.impl.AtomicReferenceImplicitUsageProvider;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;

public class FieldMayBeFinalInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("field.may.be.final.problem.descriptor", new Object[0]);
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return MakeFieldFinalFix.buildFixUnconditional((PsiField)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldMayBeFinalVisitor();
    }

    private static class FieldMayBeFinalVisitor
    extends BaseInspectionVisitor {
        private FieldMayBeFinalVisitor() {
        }

        public void visitField(PsiField field) {
            PsiClass aClass;
            super.visitField(field);
            if (field.hasModifierProperty("final")) {
                return;
            }
            if (!(field.hasModifierProperty("private") || (aClass = field.getContainingClass()) != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass))) {
                return;
            }
            if (!CanBeFinalHandler.allowToBeFinal((PsiMember)field)) {
                return;
            }
            if (!FinalUtils.canBeFinal((PsiVariable)field)) {
                return;
            }
            if (new AtomicReferenceImplicitUsageProvider().isImplicitWrite((PsiElement)field)) {
                return;
            }
            this.registerVariableError((PsiVariable)field, field);
        }
    }
}

