/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalModel {
    @NotNull
    private final PsiExpression myCondition;
    @NotNull
    private final PsiExpression myThenExpression;
    @NotNull
    private final PsiExpression myElseExpression;
    @NotNull
    private final PsiType myType;

    ConditionalModel(@NotNull PsiExpression condition2, @NotNull PsiExpression thenExpression2, @NotNull PsiExpression elseExpression2, @NotNull PsiType type2) {
        this.myCondition = condition2;
        this.myThenExpression = thenExpression2;
        this.myElseExpression = elseExpression2;
        this.myType = type2;
    }

    @NotNull
    public PsiExpression getCondition() {
        return this.myCondition;
    }

    @NotNull
    public PsiExpression getThenExpression() {
        return this.myThenExpression;
    }

    @NotNull
    public PsiExpression getElseExpression() {
        return this.myElseExpression;
    }

    @NotNull
    public PsiType getType() {
        return this.myType;
    }

    @Nullable
    public static ConditionalModel from(@NotNull PsiConditionalExpression conditional) {
        PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)conditional.getCondition());
        if (condition2 == null) {
            return null;
        }
        PsiExpression thenExpression2 = conditional.getThenExpression();
        if (thenExpression2 == null) {
            return null;
        }
        PsiExpression elseExpression2 = conditional.getElseExpression();
        if (elseExpression2 == null) {
            return null;
        }
        PsiType type2 = ConditionalModel.getType(condition2, thenExpression2, elseExpression2);
        if (type2 == null) {
            return null;
        }
        return new ConditionalModel(condition2, thenExpression2, elseExpression2, type2);
    }

    @Nullable
    static PsiType getType(@NotNull PsiExpression condition2, @NotNull PsiExpression thenExpression2, @NotNull PsiExpression elseExpression2) {
        PsiType thenType = thenExpression2.getType();
        PsiType elseType = elseExpression2.getType();
        if (thenType == null || elseType == null) {
            return null;
        }
        if (thenType.isAssignableFrom(elseType)) {
            return thenType;
        }
        if (elseType.isAssignableFrom(thenType)) {
            return elseType;
        }
        if (!(thenType instanceof PsiClassType) || !(elseType instanceof PsiClassType)) {
            return null;
        }
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)thenType) || TypeConversionUtil.isPrimitiveWrapper((PsiType)elseType)) {
            return null;
        }
        return GenericsUtil.getLeastUpperBound((PsiType)thenType, (PsiType)elseType, (PsiManager)condition2.getManager());
    }
}

