/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class SerialPersistentFieldsWithWrongSignatureInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("serialpersistentfields.with.wrong.signature.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerialPersistentFieldsWithWrongSignatureVisitor();
    }

    private static class SerialPersistentFieldsWithWrongSignatureVisitor
    extends BaseInspectionVisitor {
        private SerialPersistentFieldsWithWrongSignatureVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiField badSerialPersistentFields = null;
            for (PsiField field : fields = aClass.getFields()) {
                if (!SerialPersistentFieldsWithWrongSignatureVisitor.isSerialPersistentFields(field)) continue;
                if (!(field.hasModifierProperty("private") && field.hasModifierProperty("static") && field.hasModifierProperty("final"))) {
                    badSerialPersistentFields = field;
                    break;
                }
                PsiType type2 = field.getType();
                if (type2.equalsToText("java.io.ObjectStreamField[]")) continue;
                badSerialPersistentFields = field;
                break;
            }
            if (badSerialPersistentFields == null) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerFieldError(badSerialPersistentFields, new Object[0]);
        }

        private static boolean isSerialPersistentFields(PsiField field) {
            String fieldName = field.getName();
            return "serialPersistentFields".equals(fieldName);
        }
    }
}

