/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    VariablePassedAsArgumentVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitCallExpression(PsiCallExpression callExpression) {
        super.visitCallExpression(callExpression);
        if (this.passed) {
            return;
        }
        this.visitCall((PsiCall)callExpression);
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall((PsiCall)enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

