/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableAssignedFromVisitor
extends JavaRecursiveElementWalkingVisitor {
    private static final Logger LOG = Logger.getInstance(VariableAssignedFromVisitor.class);
    private boolean assignedFrom = false;
    @NotNull
    private final PsiVariable variable;

    VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        this.variable = variable;
    }

    public void visitFile(@NotNull PsiFile file) {
        LOG.error("Unexpectedly visited PsiFile " + file + " when tracing variable " + this.variable);
        this.stopWalking();
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
            this.stopWalking();
        }
    }

    public void visitVariable(@NotNull PsiVariable var) {
        super.visitVariable(var);
        PsiExpression initializer = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) {
            this.assignedFrom = true;
            this.stopWalking();
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }
}

