/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.RecursionVisitor;
import org.jetbrains.annotations.NotNull;

public class RecursionUtils {
    private RecursionUtils() {
    }

    public static boolean statementMayReturnBeforeRecursing(PsiStatement statement, PsiMethod method) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiThrowStatement || statement instanceof PsiExpressionListStatement || statement instanceof PsiExpressionStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement) {
            return false;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return returnValue == null || !RecursionUtils.expressionDefinitelyRecurses(returnValue, method);
        }
        if (statement instanceof PsiForStatement) {
            return RecursionUtils.forStatementMayReturnBeforeRecursing((PsiForStatement)statement, method);
        }
        if (statement instanceof PsiForeachStatement) {
            return RecursionUtils.foreachStatementMayReturnBeforeRecursing((PsiForeachStatement)statement, method);
        }
        if (statement instanceof PsiWhileStatement) {
            return RecursionUtils.whileStatementMayReturnBeforeRecursing((PsiWhileStatement)statement, method);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return RecursionUtils.doWhileStatementMayReturnBeforeRecursing((PsiDoWhileStatement)statement, method);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body2 = ((PsiSynchronizedStatement)statement).getBody();
            return RecursionUtils.codeBlockMayReturnBeforeRecursing(body2, method, false);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return RecursionUtils.codeBlockMayReturnBeforeRecursing(codeBlock, method, false);
        }
        if (statement instanceof PsiLabeledStatement) {
            return RecursionUtils.labeledStatementMayReturnBeforeRecursing((PsiLabeledStatement)statement, method);
        }
        if (statement instanceof PsiIfStatement) {
            return RecursionUtils.ifStatementMayReturnBeforeRecursing((PsiIfStatement)statement, method);
        }
        if (statement instanceof PsiTryStatement) {
            return RecursionUtils.tryStatementMayReturnBeforeRecursing((PsiTryStatement)statement, method);
        }
        if (statement instanceof PsiSwitchStatement) {
            return RecursionUtils.switchStatementMayReturnBeforeRecursing((PsiSwitchStatement)statement, method);
        }
        return true;
    }

    private static boolean doWhileStatementMayReturnBeforeRecursing(PsiDoWhileStatement loopStatement, PsiMethod method) {
        PsiStatement body2 = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body2, method);
    }

    private static boolean whileStatementMayReturnBeforeRecursing(PsiWhileStatement loopStatement, PsiMethod method) {
        PsiExpression test = loopStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, method)) {
            return false;
        }
        PsiStatement body2 = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body2, method);
    }

    private static boolean forStatementMayReturnBeforeRecursing(PsiForStatement loopStatement, PsiMethod method) {
        PsiStatement initialization = loopStatement.getInitialization();
        if (RecursionUtils.statementMayReturnBeforeRecursing(initialization, method)) {
            return true;
        }
        PsiExpression test = loopStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, method)) {
            return false;
        }
        PsiStatement body2 = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body2, method);
    }

    private static boolean foreachStatementMayReturnBeforeRecursing(PsiForeachStatement loopStatement, PsiMethod method) {
        PsiExpression test = loopStatement.getIteratedValue();
        if (RecursionUtils.expressionDefinitelyRecurses(test, method)) {
            return false;
        }
        PsiStatement body2 = loopStatement.getBody();
        return RecursionUtils.statementMayReturnBeforeRecursing(body2, method);
    }

    private static boolean switchStatementMayReturnBeforeRecursing(PsiSwitchStatement switchStatement, PsiMethod method) {
        PsiStatement[] statements;
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return true;
        }
        for (PsiStatement statement : statements = body2.getStatements()) {
            if (!RecursionUtils.statementMayReturnBeforeRecursing(statement, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementMayReturnBeforeRecursing(PsiTryStatement tryStatement, PsiMethod method) {
        PsiCodeBlock[] catchBlocks;
        PsiCodeBlock tryBlock;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            if (RecursionUtils.codeBlockMayReturnBeforeRecursing(finallyBlock, method, false)) {
                return true;
            }
            if (RecursionUtils.codeBlockDefinitelyRecurses(finallyBlock, method)) {
                return false;
            }
        }
        if (RecursionUtils.codeBlockMayReturnBeforeRecursing(tryBlock = tryStatement.getTryBlock(), method, false)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!RecursionUtils.codeBlockMayReturnBeforeRecursing(catchBlock, method, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayReturnBeforeRecursing(PsiIfStatement ifStatement, PsiMethod method) {
        PsiExpression test = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(test, method)) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (RecursionUtils.statementMayReturnBeforeRecursing(thenBranch, method)) {
            return true;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && RecursionUtils.statementMayReturnBeforeRecursing(elseBranch, method);
    }

    private static boolean labeledStatementMayReturnBeforeRecursing(PsiLabeledStatement labeledStatement, PsiMethod method) {
        PsiStatement statement = labeledStatement.getStatement();
        return RecursionUtils.statementMayReturnBeforeRecursing(statement, method);
    }

    private static boolean codeBlockMayReturnBeforeRecursing(PsiCodeBlock block, PsiMethod method, boolean endsInImplicitReturn) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (RecursionUtils.statementMayReturnBeforeRecursing(statement, method)) {
                return true;
            }
            if (!RecursionUtils.statementDefinitelyRecurses(statement, method)) continue;
            return false;
        }
        return endsInImplicitReturn;
    }

    public static boolean methodMayRecurse(@NotNull PsiMethod method) {
        RecursionVisitor recursionVisitor = new RecursionVisitor(method);
        method.accept((PsiElementVisitor)recursionVisitor);
        return recursionVisitor.isRecursive();
    }

    private static boolean expressionDefinitelyRecurses(PsiExpression exp, PsiMethod method) {
        if (exp == null) {
            return false;
        }
        if (exp instanceof PsiMethodCallExpression) {
            return RecursionUtils.methodCallExpressionDefinitelyRecurses((PsiMethodCallExpression)exp, method);
        }
        if (exp instanceof PsiNewExpression) {
            return RecursionUtils.newExpressionDefinitelyRecurses((PsiNewExpression)exp, method);
        }
        if (exp instanceof PsiAssignmentExpression) {
            return RecursionUtils.assignmentExpressionDefinitelyRecurses((PsiAssignmentExpression)exp, method);
        }
        if (exp instanceof PsiArrayInitializerExpression) {
            return RecursionUtils.arrayInitializerExpressionDefinitelyRecurses((PsiArrayInitializerExpression)exp, method);
        }
        if (exp instanceof PsiTypeCastExpression) {
            return RecursionUtils.typeCastExpressionDefinitelyRecurses((PsiTypeCastExpression)exp, method);
        }
        if (exp instanceof PsiArrayAccessExpression) {
            return RecursionUtils.arrayAccessExpressionDefinitelyRecurses((PsiArrayAccessExpression)exp, method);
        }
        if (exp instanceof PsiUnaryExpression) {
            return RecursionUtils.unaryExpressionDefinitelyRecurses((PsiUnaryExpression)exp, method);
        }
        if (exp instanceof PsiBinaryExpression) {
            return RecursionUtils.binaryExpressionDefinitelyRecurses((PsiBinaryExpression)exp, method);
        }
        if (exp instanceof PsiInstanceOfExpression) {
            return RecursionUtils.instanceOfExpressionDefinitelyRecurses((PsiInstanceOfExpression)exp, method);
        }
        if (exp instanceof PsiConditionalExpression) {
            return RecursionUtils.conditionalExpressionDefinitelyRecurses((PsiConditionalExpression)exp, method);
        }
        if (exp instanceof PsiParenthesizedExpression) {
            return RecursionUtils.parenthesizedExpressionDefinitelyRecurses((PsiParenthesizedExpression)exp, method);
        }
        if (exp instanceof PsiReferenceExpression) {
            return RecursionUtils.referenceExpressionDefinitelyRecurses((PsiReferenceExpression)exp, method);
        }
        if (exp instanceof PsiLiteralExpression || exp instanceof PsiClassObjectAccessExpression || exp instanceof PsiThisExpression || exp instanceof PsiSuperExpression) {
            return false;
        }
        return false;
    }

    private static boolean conditionalExpressionDefinitelyRecurses(PsiConditionalExpression expression2, PsiMethod method) {
        PsiExpression condExpression = expression2.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condExpression, method)) {
            return true;
        }
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        return RecursionUtils.expressionDefinitelyRecurses(thenExpression2, method) && RecursionUtils.expressionDefinitelyRecurses(elseExpression2, method);
    }

    private static boolean binaryExpressionDefinitelyRecurses(PsiBinaryExpression expression2, PsiMethod method) {
        PsiExpression lhs = expression2.getLOperand();
        if (RecursionUtils.expressionDefinitelyRecurses(lhs, method)) {
            return true;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
            return false;
        }
        PsiExpression rhs = expression2.getROperand();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, method);
    }

    private static boolean arrayAccessExpressionDefinitelyRecurses(PsiArrayAccessExpression expression2, PsiMethod method) {
        PsiExpression arrayExp = expression2.getArrayExpression();
        PsiExpression indexExp = expression2.getIndexExpression();
        return RecursionUtils.expressionDefinitelyRecurses(arrayExp, method) || RecursionUtils.expressionDefinitelyRecurses(indexExp, method);
    }

    private static boolean arrayInitializerExpressionDefinitelyRecurses(PsiArrayInitializerExpression expression2, PsiMethod method) {
        PsiExpression[] initializers;
        for (PsiExpression initializer : initializers = expression2.getInitializers()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(initializer, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean unaryExpressionDefinitelyRecurses(PsiUnaryExpression expression2, PsiMethod method) {
        PsiExpression operand2 = expression2.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(operand2, method);
    }

    private static boolean instanceOfExpressionDefinitelyRecurses(PsiInstanceOfExpression expression2, PsiMethod method) {
        PsiExpression operand2 = expression2.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(operand2, method);
    }

    private static boolean parenthesizedExpressionDefinitelyRecurses(PsiParenthesizedExpression expression2, PsiMethod method) {
        PsiExpression innerExpression = expression2.getExpression();
        return RecursionUtils.expressionDefinitelyRecurses(innerExpression, method);
    }

    private static boolean referenceExpressionDefinitelyRecurses(PsiReferenceExpression expression2, PsiMethod method) {
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        return qualifierExpression2 != null && RecursionUtils.expressionDefinitelyRecurses(qualifierExpression2, method);
    }

    private static boolean typeCastExpressionDefinitelyRecurses(PsiTypeCastExpression expression2, PsiMethod method) {
        PsiExpression operand2 = expression2.getOperand();
        return RecursionUtils.expressionDefinitelyRecurses(operand2, method);
    }

    private static boolean assignmentExpressionDefinitelyRecurses(PsiAssignmentExpression assignmentExpression, PsiMethod method) {
        PsiExpression rhs = assignmentExpression.getRExpression();
        PsiExpression lhs = assignmentExpression.getLExpression();
        return RecursionUtils.expressionDefinitelyRecurses(rhs, method) || RecursionUtils.expressionDefinitelyRecurses(lhs, method);
    }

    private static boolean newExpressionDefinitelyRecurses(PsiNewExpression exp, PsiMethod method) {
        PsiExpression[] arrayDimensions;
        for (PsiExpression arrayDimension : arrayDimensions = exp.getArrayDimensions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(arrayDimension, method)) continue;
            return true;
        }
        PsiArrayInitializerExpression arrayInitializer = exp.getArrayInitializer();
        if (RecursionUtils.expressionDefinitelyRecurses((PsiExpression)arrayInitializer, method)) {
            return true;
        }
        PsiExpression qualifier = exp.getQualifier();
        if (RecursionUtils.expressionDefinitelyRecurses(qualifier, method)) {
            return true;
        }
        PsiExpressionList argumentList = exp.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList.getExpressions()) {
                if (!RecursionUtils.expressionDefinitelyRecurses(arg, method)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean methodCallExpressionDefinitelyRecurses(PsiMethodCallExpression exp, PsiMethod method) {
        PsiExpression[] args;
        PsiExpression qualifier;
        PsiReferenceExpression methodExpression = exp.getMethodExpression();
        PsiMethod referencedMethod = exp.resolveMethod();
        if (referencedMethod == null) {
            return false;
        }
        if (referencedMethod.equals(method)) {
            if (method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                return true;
            }
            qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return true;
            }
        }
        if (RecursionUtils.expressionDefinitelyRecurses(qualifier = methodExpression.getQualifierExpression(), method)) {
            return true;
        }
        PsiExpressionList argumentList = exp.getArgumentList();
        for (PsiExpression arg : args = argumentList.getExpressions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(arg, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean statementDefinitelyRecurses(PsiStatement statement, PsiMethod method) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiThrowStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions2;
            PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)statement;
            PsiExpressionList expressionList = expressionListStatement.getExpressionList();
            if (expressionList == null) {
                return false;
            }
            for (PsiExpression expression2 : expressions2 = expressionList.getExpressions()) {
                if (!RecursionUtils.expressionDefinitelyRecurses(expression2, method)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression3 = expressionStatement.getExpression();
            return RecursionUtils.expressionDefinitelyRecurses(expression3, method);
        }
        if (statement instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements;
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
            for (PsiElement declaredElement : declaredElements = declaration2.getDeclaredElements()) {
                PsiLocalVariable variable;
                PsiExpression initializer;
                if (!(declaredElement instanceof PsiLocalVariable) || !RecursionUtils.expressionDefinitelyRecurses(initializer = (variable = (PsiLocalVariable)declaredElement).getInitializer(), method)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return returnValue != null && RecursionUtils.expressionDefinitelyRecurses(returnValue, method);
        }
        if (statement instanceof PsiForStatement) {
            return RecursionUtils.forStatementDefinitelyRecurses((PsiForStatement)statement, method);
        }
        if (statement instanceof PsiForeachStatement) {
            return RecursionUtils.foreachStatementDefinitelyRecurses((PsiForeachStatement)statement, method);
        }
        if (statement instanceof PsiWhileStatement) {
            return RecursionUtils.whileStatementDefinitelyRecurses((PsiWhileStatement)statement, method);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return RecursionUtils.doWhileStatementDefinitelyRecurses((PsiDoWhileStatement)statement, method);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body2 = ((PsiSynchronizedStatement)statement).getBody();
            return RecursionUtils.codeBlockDefinitelyRecurses(body2, method);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            return RecursionUtils.codeBlockDefinitelyRecurses(codeBlock, method);
        }
        if (statement instanceof PsiLabeledStatement) {
            return RecursionUtils.labeledStatementDefinitelyRecurses((PsiLabeledStatement)statement, method);
        }
        if (statement instanceof PsiIfStatement) {
            return RecursionUtils.ifStatementDefinitelyRecurses((PsiIfStatement)statement, method);
        }
        if (statement instanceof PsiTryStatement) {
            return RecursionUtils.tryStatementDefinitelyRecurses((PsiTryStatement)statement, method);
        }
        if (statement instanceof PsiSwitchStatement) {
            return RecursionUtils.switchStatementDefinitelyRecurses((PsiSwitchStatement)statement, method);
        }
        return false;
    }

    private static boolean switchStatementDefinitelyRecurses(PsiSwitchStatement switchStatement, PsiMethod method) {
        PsiExpression switchExpression = switchStatement.getExpression();
        return RecursionUtils.expressionDefinitelyRecurses(switchExpression, method);
    }

    private static boolean tryStatementDefinitelyRecurses(PsiTryStatement tryStatement, PsiMethod method) {
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (RecursionUtils.codeBlockDefinitelyRecurses(tryBlock, method)) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return RecursionUtils.codeBlockDefinitelyRecurses(finallyBlock, method);
    }

    private static boolean codeBlockDefinitelyRecurses(PsiCodeBlock block, PsiMethod method) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (!RecursionUtils.statementDefinitelyRecurses(statement, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementDefinitelyRecurses(PsiIfStatement ifStatement, PsiMethod method) {
        PsiExpression condition2 = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition2, method)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (thenBranch == null) {
            return false;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        if (value2 == Boolean.TRUE) {
            return RecursionUtils.statementDefinitelyRecurses(thenBranch, method);
        }
        if (value2 == Boolean.FALSE) {
            return elseBranch != null && RecursionUtils.statementDefinitelyRecurses(elseBranch, method);
        }
        return RecursionUtils.statementDefinitelyRecurses(thenBranch, method) && RecursionUtils.statementDefinitelyRecurses(elseBranch, method);
    }

    private static boolean forStatementDefinitelyRecurses(PsiForStatement forStatement, PsiMethod method) {
        PsiStatement initialization = forStatement.getInitialization();
        if (RecursionUtils.statementDefinitelyRecurses(initialization, method)) {
            return true;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition2, method)) {
            return true;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        if (value2 == Boolean.TRUE) {
            PsiStatement body2 = forStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body2, method);
        }
        return false;
    }

    private static boolean foreachStatementDefinitelyRecurses(PsiForeachStatement foreachStatement, PsiMethod method) {
        PsiExpression iteration = foreachStatement.getIteratedValue();
        return RecursionUtils.expressionDefinitelyRecurses(iteration, method);
    }

    private static boolean whileStatementDefinitelyRecurses(PsiWhileStatement whileStatement, PsiMethod method) {
        PsiExpression condition2 = whileStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition2, method)) {
            return true;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(condition2);
        if (value2 == Boolean.TRUE) {
            PsiStatement body2 = whileStatement.getBody();
            return RecursionUtils.statementDefinitelyRecurses(body2, method);
        }
        return false;
    }

    private static boolean doWhileStatementDefinitelyRecurses(PsiDoWhileStatement doWhileStatement, PsiMethod method) {
        PsiStatement body2 = doWhileStatement.getBody();
        if (RecursionUtils.statementDefinitelyRecurses(body2, method)) {
            return true;
        }
        PsiExpression condition2 = doWhileStatement.getCondition();
        return RecursionUtils.expressionDefinitelyRecurses(condition2, method);
    }

    private static boolean labeledStatementDefinitelyRecurses(PsiLabeledStatement labeledStatement, PsiMethod method) {
        PsiStatement body2 = labeledStatement.getStatement();
        return RecursionUtils.statementDefinitelyRecurses(body2, method);
    }

    public static boolean methodDefinitelyRecurses(@NotNull PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        return body2 != null && !RecursionUtils.codeBlockMayReturnBeforeRecursing(body2, method, true);
    }
}

