/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class FunctionalExpressionUtils {
    public static boolean isFunctionalReferenceTo(PsiExpression expression2, String className2, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            if (!methodName.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)methodRef.getQualifier(), PsiReferenceExpression.class);
            return ref != null && method != null && MethodUtils.methodMatches(method, className2, returnType, methodName, parameterTypes) && method.getContainingClass() != null && ref.isReferenceTo((PsiElement)method.getContainingClass());
        }
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiExpression body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)body2, PsiMethodCallExpression.class);
            if (call == null || !MethodCallUtils.isCallToMethod(call, className2, returnType, methodName, parameterTypes)) {
                return false;
            }
            Object[] parameters2 = lambda2.getParameterList().getParameters();
            Object[] args = call.getArgumentList().getExpressions();
            PsiMethod method = call.resolveMethod();
            if (method != null && !method.hasModifierProperty("static")) {
                args = (PsiExpression[])ArrayUtil.prepend((Object)call.getMethodExpression().getQualifierExpression(), (Object[])args);
            }
            if (parameters2.length != args.length || StreamEx.zip((Object[])args, (Object[])parameters2, ExpressionUtils::isReferenceTo).has((Object)false)) {
                return false;
            }
            return MethodCallUtils.isCallToMethod(call, className2, returnType, methodName, parameterTypes);
        }
        return false;
    }

    @Nullable
    public static PsiClass getClassOfDefaultConstructorFunction(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            if (!methodRef.isConstructor()) {
                return null;
            }
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)methodRef.getFunctionalInterfaceType());
            if (method == null || !method.getParameterList().isEmpty()) {
                return null;
            }
            PsiTypeElement type2 = methodRef.getQualifierType();
            if (type2 == null) {
                if (methodRef.getQualifier() instanceof PsiReference) {
                    return (PsiClass)ObjectUtils.tryCast((Object)((PsiReference)methodRef.getQualifier()).resolve(), PsiClass.class);
                }
                return null;
            }
            return PsiUtil.resolveClassInClassTypeOnly((PsiType)type2.getType());
        }
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            if (!lambda2.getParameterList().isEmpty()) {
                return null;
            }
            PsiExpression body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
            if (!(body2 instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)body2;
            PsiExpressionList args = newExpression.getArgumentList();
            if (args == null || !args.isEmpty() || newExpression.getAnonymousClass() != null) {
                return null;
            }
            PsiJavaCodeReferenceElement classRef = newExpression.getClassReference();
            return classRef == null ? null : (PsiClass)ObjectUtils.tryCast((Object)classRef.resolve(), PsiClass.class);
        }
        return null;
    }

    public static PsiType getFunctionalExpressionType(PsiExpression expression2) {
        PsiType argumentType = expression2 instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)expression2).getFunctionalInterfaceType() : expression2.getType();
        return argumentType;
    }
}

