/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import one.util.streamex.Joining;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSwitchBranchesUtil {
    @NotNull
    public static String getActionName(Collection<String> names2) {
        if (names2.size() == 1) {
            return "Create missing switch branch '" + names2.iterator().next() + "'";
        }
        return "Create missing branches: " + CreateSwitchBranchesUtil.formatMissingBranches(names2);
    }

    public static String formatMissingBranches(Collection<String> names2) {
        return (String)StreamEx.of(names2).map(name2 -> name2.startsWith("'") || name2.startsWith("\"") ? name2 : "'" + name2 + "'").mapLast("and "::concat).collect((Collector)Joining.with((CharSequence)", ").maxChars(50).cutAfterDelimiter());
    }

    public static List<PsiSwitchLabelStatementBase> createMissingBranches(@NotNull PsiSwitchBlock switchBlock, @NotNull List<String> allNames, @NotNull Collection<String> missingNames, @NotNull Function<PsiSwitchLabelStatementBase, List<String>> caseExtractor) {
        boolean isRuleBasedFormat = SwitchUtils.isRuleFormatSwitch(switchBlock);
        PsiCodeBlock body2 = switchBlock.getBody();
        if (body2 == null) {
            StringBuilder newStatementText = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            PsiExpression switchExpression = switchBlock.getExpression();
            newStatementText.append("switch(").append(switchExpression == null ? "" : commentTracker.text((PsiElement)switchExpression)).append("){");
            for (String missingName : missingNames) {
                newStatementText.append(String.join((CharSequence)"", CreateSwitchBranchesUtil.generateStatements(missingName, switchBlock, isRuleBasedFormat)));
            }
            newStatementText.append('}');
            PsiSwitchBlock block = (PsiSwitchBlock)commentTracker.replaceAndRestoreComments((PsiElement)switchBlock, newStatementText.toString());
            return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)block.getBody(), PsiSwitchLabelStatementBase.class);
        }
        Map prevToNext = StreamEx.of(allNames).pairMap(Couple::of).toMap(c -> (String)c.getFirst(), c -> (String)c.getSecond());
        List missingLabels = ((StreamEx)StreamEx.of(allNames).filter(missingNames::contains)).toList();
        String nextLabel = CreateSwitchBranchesUtil.getNextLabel(prevToNext, missingLabels);
        ArrayList<PsiSwitchLabelStatementBase> addedLabels = new ArrayList<PsiSwitchLabelStatementBase>();
        for (PsiElement bodyElement = body2.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
            PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)bodyElement, PsiSwitchLabelStatementBase.class);
            if (label == null) continue;
            List<String> constants = caseExtractor.apply(label);
            while (nextLabel != null && constants.contains(nextLabel)) {
                addedLabels.add(CreateSwitchBranchesUtil.addSwitchLabelStatementBefore((String)missingLabels.get(0), bodyElement, switchBlock, isRuleBasedFormat));
                missingLabels.remove(0);
                if (missingLabels.isEmpty()) break;
                nextLabel = CreateSwitchBranchesUtil.getNextLabel(prevToNext, missingLabels);
            }
            if (!label.isDefaultCase()) continue;
            for (String missingEnumElement : missingLabels) {
                addedLabels.add(CreateSwitchBranchesUtil.addSwitchLabelStatementBefore(missingEnumElement, bodyElement, switchBlock, isRuleBasedFormat));
            }
            missingLabels.clear();
            break;
        }
        if (!missingLabels.isEmpty()) {
            PsiElement lastChild = body2.getLastChild();
            for (String missingEnumElement : missingLabels) {
                addedLabels.add(CreateSwitchBranchesUtil.addSwitchLabelStatementBefore(missingEnumElement, lastChild, switchBlock, isRuleBasedFormat));
            }
        }
        return addedLabels;
    }

    public static void createTemplate(@NotNull PsiSwitchBlock block, List<PsiSwitchLabelStatementBase> addedLabels) {
        if (!(block instanceof PsiSwitchExpression)) {
            return;
        }
        List pointers = ContainerUtil.map(addedLabels, SmartPointerManager::createPointer);
        Editor editor = CreateSwitchBranchesUtil.prepareForTemplateAndObtainEditor((PsiElement)block);
        if (editor == null) {
            return;
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)block);
        List<PsiExpression> elementsToReplace = CreateSwitchBranchesUtil.getElementsToReplace(pointers);
        for (PsiExpression expression2 : elementsToReplace) {
            builder.replaceElement((PsiElement)expression2, (Expression)new ConstantNode(expression2.getText()));
        }
        builder.run(editor, true);
    }

    @NotNull
    private static List<PsiExpression> getElementsToReplace(@NotNull List<SmartPsiElementPointer<PsiSwitchLabelStatementBase>> labels2) {
        ArrayList<PsiExpression> elementsToReplace = new ArrayList<PsiExpression>();
        for (SmartPsiElementPointer<PsiSwitchLabelStatementBase> pointer : labels2) {
            PsiSwitchLabelStatementBase label = (PsiSwitchLabelStatementBase)pointer.getElement();
            if (label == null) continue;
            if (label instanceof PsiSwitchLabeledRuleStatement) {
                PsiStatement body2 = ((PsiSwitchLabeledRuleStatement)label).getBody();
                if (!(body2 instanceof PsiExpressionStatement)) continue;
                ContainerUtil.addIfNotNull(elementsToReplace, (Object)((PsiExpressionStatement)body2).getExpression());
                continue;
            }
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)label);
            if (!(next instanceof PsiYieldStatement)) continue;
            ContainerUtil.addIfNotNull(elementsToReplace, (Object)((PsiYieldStatement)next).getExpression());
        }
        return elementsToReplace;
    }

    private static List<String> generateStatements(String name2, PsiSwitchBlock switchBlock, boolean isRuleBasedFormat) {
        if (switchBlock instanceof PsiSwitchExpression) {
            String value2 = TypeUtils.getDefaultValue(((PsiSwitchExpression)switchBlock).getType());
            if (isRuleBasedFormat) {
                return Collections.singletonList("case " + name2 + " -> " + value2 + ";");
            }
            return Arrays.asList("case " + name2 + ":", "yield " + value2 + ";");
        }
        if (isRuleBasedFormat) {
            return Collections.singletonList("case " + name2 + " -> {}");
        }
        return Arrays.asList("case " + name2 + ":", "break;");
    }

    private static PsiSwitchLabelStatementBase addSwitchLabelStatementBefore(String labelExpression, PsiElement anchor, PsiSwitchBlock switchBlock, boolean isRuleBasedFormat) {
        if (anchor instanceof PsiSwitchLabelStatement) {
            PsiElement sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            while (sibling instanceof PsiSwitchLabelStatement) {
                anchor = sibling;
                sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            }
        }
        PsiElement correctedAnchor = anchor;
        PsiElement parent = anchor.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
        PsiSwitchLabelStatementBase result = null;
        for (String text2 : CreateSwitchBranchesUtil.generateStatements(labelExpression, switchBlock, isRuleBasedFormat)) {
            PsiStatement statement = factory.createStatementFromText(text2, parent);
            PsiElement inserted = parent.addBefore((PsiElement)statement, correctedAnchor);
            if (!(inserted instanceof PsiSwitchLabelStatementBase)) continue;
            result = (PsiSwitchLabelStatementBase)inserted;
        }
        return result;
    }

    private static String getNextLabel(Map<String, String> nextLabels, List<String> missingLabels) {
        String nextLabel = nextLabels.get(missingLabels.get(0));
        while (missingLabels.contains(nextLabel)) {
            nextLabel = nextLabels.get(nextLabel);
        }
        return nextLabel;
    }

    @Nullable
    public static Editor prepareForTemplateAndObtainEditor(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (!file.isPhysical()) {
            return null;
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        if (topLevelFile == null || document != topLevelFile.getViewProvider().getDocument()) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        return editor;
    }
}

