/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountingLoop {
    @NotNull
    final PsiLocalVariable myCounter;
    @NotNull
    final PsiLoopStatement myLoop;
    @NotNull
    final PsiExpression myInitializer;
    @NotNull
    final PsiExpression myBound;
    final boolean myIncluding;
    final boolean myDescending;

    private CountingLoop(@NotNull PsiLoopStatement loop, @NotNull PsiLocalVariable counter, @NotNull PsiExpression initializer, @NotNull PsiExpression bound, boolean including, boolean descending) {
        this.myInitializer = initializer;
        this.myCounter = counter;
        this.myLoop = loop;
        this.myBound = bound;
        this.myIncluding = including;
        this.myDescending = descending;
    }

    @NotNull
    public PsiLocalVariable getCounter() {
        return this.myCounter;
    }

    @NotNull
    public PsiLoopStatement getLoop() {
        return this.myLoop;
    }

    @NotNull
    public PsiExpression getInitializer() {
        return this.myInitializer;
    }

    @NotNull
    public PsiExpression getBound() {
        return this.myBound;
    }

    public boolean isIncluding() {
        return this.myIncluding;
    }

    public boolean isDescending() {
        return this.myDescending;
    }

    @Nullable
    public static CountingLoop from(PsiForStatement forStatement) {
        PsiExpression bound;
        boolean descending;
        PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)forStatement.getInitialization(), PsiDeclarationStatement.class);
        if (initialization == null || initialization.getDeclaredElements().length != 1) {
            return null;
        }
        PsiLocalVariable counter = (PsiLocalVariable)ObjectUtils.tryCast((Object)initialization.getDeclaredElements()[0], PsiLocalVariable.class);
        if (counter == null) {
            return null;
        }
        if (!counter.getType().equals(PsiType.INT) && !counter.getType().equals(PsiType.LONG)) {
            return null;
        }
        PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)counter.getInitializer());
        if (initializer == null) {
            return null;
        }
        if (VariableAccessUtils.variableIsIncremented((PsiVariable)counter, forStatement.getUpdate())) {
            descending = false;
        } else if (VariableAccessUtils.variableIsDecremented((PsiVariable)counter, forStatement.getUpdate())) {
            descending = true;
        } else {
            return null;
        }
        PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)forStatement.getCondition()), PsiBinaryExpression.class);
        if (condition2 == null) {
            return null;
        }
        IElementType type2 = condition2.getOperationTokenType();
        boolean closed = false;
        RelationType relationType = RelationType.fromElementType(type2);
        if (relationType == null || !relationType.isInequality()) {
            return null;
        }
        if (relationType.isSubRelation(RelationType.EQ)) {
            closed = true;
        }
        if (descending) {
            relationType = relationType.getFlipped();
            assert (relationType != null);
        }
        if ((bound = ExpressionUtils.getOtherOperand(condition2, (PsiVariable)counter)) == null) {
            return null;
        }
        if (bound == condition2.getLOperand()) {
            relationType = relationType.getFlipped();
            assert (relationType != null);
        }
        if (!relationType.isSubRelation(RelationType.LT)) {
            return null;
        }
        if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)counter.getType(), (PsiExpression)bound)) {
            return null;
        }
        if (VariableAccessUtils.variableIsAssigned((PsiVariable)counter, (PsiElement)forStatement.getBody())) {
            return null;
        }
        return new CountingLoop((PsiLoopStatement)forStatement, counter, initializer, bound, closed, descending);
    }
}

