/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class HardcodedLineSeparatorsInspection
extends BaseInspection {
    private static final Pattern newlines = Pattern.compile("\\\\n|\\\\r|\\\\0?12|\\\\0?15");

    @NotNull
    public String getID() {
        return "HardcodedLineSeparator";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("hardcoded.line.separator.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedLineSeparatorsVisitor();
    }

    private static class HardcodedLineSeparatorsVisitor
    extends BaseInspectionVisitor {
        private HardcodedLineSeparatorsVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (type2 == null || !TypeUtils.isJavaLangString(type2) && !type2.equals(PsiType.CHAR)) {
                return;
            }
            String text2 = expression2.getText();
            Matcher matcher = newlines.matcher(text2);
            int end = 0;
            while (matcher.find(end)) {
                int start = matcher.start();
                end = matcher.end();
                this.registerErrorAtOffset((PsiElement)expression2, start, end - start, new Object[0]);
            }
        }
    }
}

