/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.CollectionReplaceableByEnumCollectionVisitor;
import com.siyeh.ig.performance.ReplaceExpressionWithTextFix;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetReplaceableByEnumSetInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("set.replaceable.by.enum.set.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 1) {
            return null;
        }
        PsiLocalVariable localVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)infos[0], PsiLocalVariable.class);
        if (localVariable == null) {
            return null;
        }
        PsiType[] parameters2 = CollectionReplaceableByEnumCollectionVisitor.extractParameterType(localVariable, 1);
        if (parameters2 == null) {
            return null;
        }
        PsiType enumParameter = parameters2[0];
        PsiClass probablyEnum = PsiUtil.resolveClassInClassTypeOnly((PsiType)enumParameter);
        if (probablyEnum == null || !probablyEnum.isEnum()) {
            return null;
        }
        String text2 = "java.util.EnumSet.noneOf(" + enumParameter.getCanonicalText() + ".class)";
        return new ReplaceExpressionWithTextFix(text2, CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"EnumSet"}));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SetReplaceableByEnumSetVisitor();
    }

    private static class SetReplaceableByEnumSetVisitor
    extends CollectionReplaceableByEnumCollectionVisitor {
        private SetReplaceableByEnumSetVisitor() {
        }

        @Override
        @NotNull
        protected List<String> getUnreplaceableCollectionNames() {
            return Arrays.asList("java.util.concurrent.CopyOnWriteArraySet", "java.util.concurrent.ConcurrentSkipListSet", "java.util.LinkedHashSet");
        }

        @Override
        @NotNull
        protected List<String> getReplaceableCollectionNames() {
            return Collections.singletonList("java.util.HashSet");
        }

        @Override
        @NotNull
        protected String getReplacementCollectionName() {
            return "java.util.EnumSet";
        }

        @Override
        @NotNull
        protected String getBaseCollectionName() {
            return "java.util.Set";
        }
    }
}

