/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public class ClassOnlyUsedInOnePackageInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner2 = refClass.getOwner();
        if (!(owner2 instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        RefPackage otherPackage = null;
        for (RefClass refClass2 : dependencies) {
            RefPackage refPackage = RefJavaUtil.getPackage((RefEntity)refClass2);
            if (owner2 == refPackage) {
                return null;
            }
            if (otherPackage == refPackage) continue;
            if (otherPackage == null) {
                otherPackage = refPackage;
                continue;
            }
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            RefPackage refPackage = RefJavaUtil.getPackage((RefEntity)dependent);
            if (owner2 == refPackage) {
                return null;
            }
            if (otherPackage == refPackage) continue;
            if (otherPackage == null) {
                otherPackage = refPackage;
                continue;
            }
            return null;
        }
        if (otherPackage == null) {
            return null;
        }
        PsiElement psiElement = UDeclarationKt.getAnchorPsi((UDeclaration)refClass.getUastElement());
        if (psiElement == null) {
            return null;
        }
        String packageName = otherPackage.getName();
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(psiElement, InspectionGadgetsBundle.message("class.only.used.in.one.package.problem.descriptor", packageName), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }
}

