/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.InspectionGadgetsBundle;

public class AbstractTestClassNamingConvention
extends NamingConvention<PsiClass> {
    private static final int DEFAULT_MIN_LENGTH = 12;
    private static final int DEFAULT_MAX_LENGTH = 64;
    public static final String ABSTRACT_TEST_CLASS_NAMING_CONVENTION_SHORT_NAME = "JUnitAbstractTestClassNamingConvention";

    public NamingConventionBean createDefaultBean() {
        return new NamingConventionBean("[A-Z][A-Za-z\\d]*TestCase", 12, 64, new String[0]);
    }

    public String getElementDescription() {
        return InspectionGadgetsBundle.message("junit.abstract.test.class.naming.convention.element.description", new Object[0]);
    }

    public boolean isApplicable(PsiClass aClass) {
        if (aClass.hasModifierProperty("abstract")) {
            TestFramework framework = TestFrameworks.detectFramework((PsiClass)aClass);
            return framework != null && framework.isTestClass((PsiElement)aClass);
        }
        return false;
    }

    public String getShortName() {
        return ABSTRACT_TEST_CLASS_NAMING_CONVENTION_SHORT_NAME;
    }
}

