/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ArrayLengthInLoopConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("array.length.in.loop.condition.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayLengthInLoopConditionVisitor();
    }

    private static class ArrayLengthInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private ArrayLengthInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            super.visitForStatement(statement);
            this.checkCondition((PsiConditionalLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            this.checkCondition((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            this.checkCondition((PsiConditionalLoopStatement)statement);
        }

        public void checkCondition(@NotNull PsiConditionalLoopStatement statement) {
            PsiExpression condition2 = statement.getCondition();
            if (condition2 == null) {
                return;
            }
            this.checkForArrayLength(condition2);
        }

        private void checkForArrayLength(PsiExpression condition2) {
            condition2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)expression2) != null) {
                        this.registerError(Objects.requireNonNull(expression2.getReferenceNameElement()), new Object[0]);
                    }
                }
            });
        }
    }
}

