/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public class AbstractClassWithOnlyOneDirectInheritorInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.class.with.only.one.direct.inheritor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassWithOnlyOneDirectInheritorVisitor();
    }

    private static class AbstractClassWithOnlyOneDirectInheritorVisitor
    extends BaseInspectionVisitor {
        private AbstractClassWithOnlyOneDirectInheritorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!InheritanceUtil.hasOneInheritor(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

