/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import com.siyeh.ig.fixes.MakeMethodFinalFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class OverridableMethodCallDuringObjectConstructionInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        PsiClass callClass = ClassUtils.getContainingClass((PsiElement)methodCallExpression);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null || callClass == null || MethodUtils.isOverriddenInHierarchy(method, callClass)) {
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        SmartList fixes = new SmartList();
        if (!callClass.hasModifierProperty("abstract")) {
            fixes.add(new MakeClassFinalFix(callClass));
        }
        if (!(method instanceof PsiCompiledElement) && !method.hasModifierProperty("abstract")) {
            fixes.add(new MakeMethodFinalFix(method.getName()));
        }
        return fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("overridable.method.call.in.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverridableMethodCallInConstructorVisitor();
    }

    private static class OverridableMethodCallInConstructorVisitor
    extends BaseInspectionVisitor {
        private OverridableMethodCallInConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallDuringObjectConstruction(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
            if (containingClass == null || containingClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod calledMethod = expression2.resolveMethod();
            if (calledMethod == null || !PsiUtil.canBeOverridden((PsiMethod)calledMethod) || calledMethod.hasModifierProperty("packageLocal")) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }
    }
}

