/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public class RemoveRedundantPolyadicOperandFix
extends InspectionGadgetsFix {
    private final String myExpressionText;

    public RemoveRedundantPolyadicOperandFix(String expressionText) {
        this.myExpressionText = expressionText;
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("remove.redundant.polyadic.operand.fix.name", this.myExpressionText);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("remove.redundant.polyadic.operand.fix.family.name", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class);
        if (polyadicExpression == null) {
            return;
        }
        Object[] children = polyadicExpression.getChildren();
        int start = IntStreamEx.ofIndices((Object[])children, child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)element, (boolean)false)).findFirst().orElse(-1);
        if (start == -1) {
            return;
        }
        int end = IntStreamEx.range((int)(start + 1), (int)children.length).findFirst(arg_0 -> RemoveRedundantPolyadicOperandFix.lambda$doFix$1((PsiElement[])children, arg_0)).orElse(-1);
        if (end == -1) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String replacement = IntStreamEx.range((int)0, (int)start).append((IntStream)IntStreamEx.range((int)end, (int)children.length)).elements(children).map(ct::text).joining();
        ct.replaceAndRestoreComments((PsiElement)polyadicExpression, replacement);
    }

    private static /* synthetic */ boolean lambda$doFix$1(PsiElement[] children, int idx) {
        return children[idx] instanceof PsiExpression;
    }
}

