/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSwitchFix
implements LocalQuickFix,
IntentionAction {
    protected final SmartPsiElementPointer<PsiSwitchBlock> myBlock;

    public BaseSwitchFix(@NotNull PsiSwitchBlock block) {
        this.myBlock = SmartPointerManager.createPointer((PsiElement)block);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        this.invoke();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.invoke();
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected abstract void invoke();

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiSwitchBlock startSwitch = (PsiSwitchBlock)this.myBlock.getElement();
        if (startSwitch == null) {
            return false;
        }
        int offset = Math.min(editor.getCaretModel().getOffset(), startSwitch.getTextRange().getEndOffset() - 1);
        PsiSwitchBlock currentSwitch = (PsiSwitchBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.findElementAt(offset), (Class[])new Class[]{PsiSwitchBlock.class});
        return currentSwitch == startSwitch;
    }
}

