/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddArgumentFix
extends InspectionGadgetsFix {
    private final String myExpressionText;
    private final String myPresentableText;

    public AddArgumentFix(String expressionText, String presentableText) {
        this.myExpressionText = expressionText;
        this.myPresentableText = presentableText;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiMethodCallExpression call;
        PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiReferenceExpression.class);
        if (ref == null) {
            return;
        }
        if (ref instanceof PsiMethodReferenceExpression) {
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)ref, true, true);
            if (lambda2 == null) {
                return;
            }
            call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)lambda2.getBody(), PsiMethodCallExpression.class);
        } else {
            call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
        }
        if (call == null) {
            return;
        }
        PsiElement result = call.getArgumentList().add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(this.myExpressionText, (PsiElement)call));
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    @Nls
    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("fix.add.argument.name", this.myPresentableText);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("fix.add.argument.family.name", new Object[0]);
    }
}

