/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.fixes.EncapsulateVariableFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicFieldInspection
extends BaseInspection {
    public boolean ignoreEnums = false;
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet("org.junit.runners.Parameterized.Parameter");

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        panel2.add((Component)annotationsListControl, "Center");
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("public.field.ignore.enum.type.fields.option", new Object[0]), (InspectionProfileEntry)this, "ignoreEnums");
        panel2.add((Component)checkBox, "South");
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiField field = (PsiField)infos[0];
        fixes.add(new EncapsulateVariableFix(field.getName()));
        AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, (List<String>)((Object)this.ignorableAnnotations), fixes);
        return fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("public.field.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldVisitor();
    }

    private class PublicFieldVisitor
    extends BaseInspectionVisitor {
        private PublicFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (Collection)((Object)PublicFieldInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                PsiClassType classType;
                PsiClass aClass;
                if (field.hasModifierProperty("static")) {
                    return;
                }
                PsiType type2 = field.getType();
                if (ClassUtils.isImmutable(type2)) {
                    return;
                }
                if (PublicFieldInspection.this.ignoreEnums && type2 instanceof PsiClassType && (aClass = (classType = (PsiClassType)type2).resolve()) != null && aClass.isEnum()) {
                    return;
                }
            }
            this.registerFieldError(field, field);
        }
    }
}

