/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.CreateMissingSwitchBranchesFix;
import com.siyeh.ig.psiutils.CreateSwitchBranchesUtil;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSwitchStatementWhichMissesCasesInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean ignoreSwitchStatementsWithDefault = true;

    @NotNull
    static String buildErrorString(String enumName, Set<String> names2) {
        if (names2.size() == 1) {
            return InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor.single", enumName, names2.iterator().next());
        }
        String namesString = CreateSwitchBranchesUtil.formatMissingBranches(names2);
        return InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor", enumName, namesString);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchStatementsWithDefault");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                this.processSwitchBlock((PsiSwitchBlock)statement);
            }

            public void visitSwitchExpression(PsiSwitchExpression expression2) {
                this.processSwitchBlock((PsiSwitchBlock)expression2);
            }

            public void processSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
                PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)switchBlock.getExpression());
                if (expression2 == null) {
                    return;
                }
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                if (aClass == null || !aClass.isEnum()) {
                    return;
                }
                Set constants = (Set)StreamEx.of((Object[])aClass.getAllFields()).select(PsiEnumConstant.class).map(PsiField::getName).toCollection(LinkedHashSet::new);
                if (constants.isEmpty()) {
                    return;
                }
                boolean hasDefault = false;
                ProblemHighlightType highlighting = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                for (PsiSwitchLabelStatementBase child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)switchBlock.getBody(), PsiSwitchLabelStatementBase.class)) {
                    if (child.isDefaultCase()) {
                        hasDefault = true;
                        if (!EnumSwitchStatementWhichMissesCasesInspection.this.ignoreSwitchStatementsWithDefault) continue;
                        if (!isOnTheFly) {
                            return;
                        }
                        highlighting = ProblemHighlightType.INFORMATION;
                        continue;
                    }
                    List<PsiEnumConstant> enumConstants = SwitchUtils.findEnumConstants(child);
                    if (enumConstants.isEmpty()) {
                        return;
                    }
                    for (PsiEnumConstant constant : enumConstants) {
                        if (constant.getContainingClass() != aClass) {
                            return;
                        }
                        constants.remove(constant.getName());
                    }
                }
                if (!hasDefault && switchBlock instanceof PsiSwitchExpression) {
                    return;
                }
                if (constants.isEmpty()) {
                    return;
                }
                CommonDataflow.DataflowResult dataflow = CommonDataflow.getDataflowResult(expression2);
                if (dataflow != null) {
                    DfType type2 = dataflow.getDfType(expression2);
                    Set<Object> notValues = type2 instanceof DfAntiConstantType ? ((DfAntiConstantType)type2).getNotValues() : Collections.emptySet();
                    for (Object value2 : notValues) {
                        if (!(value2 instanceof PsiEnumConstant)) continue;
                        constants.remove(((PsiEnumConstant)value2).getName());
                    }
                    Set values = StreamEx.of(dataflow.getExpressionValues(expression2)).select(PsiEnumConstant.class).map(PsiField::getName).toSet();
                    if (!values.isEmpty()) {
                        constants.retainAll(values);
                    }
                }
                if (constants.isEmpty()) {
                    return;
                }
                String message2 = EnumSwitchStatementWhichMissesCasesInspection.buildErrorString(aClass.getQualifiedName(), constants);
                CreateMissingSwitchBranchesFix fix = new CreateMissingSwitchBranchesFix(switchBlock, constants);
                if (highlighting == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)EnumSwitchStatementWhichMissesCasesInspection.this.getShortName(), (PsiElement)switchBlock)) {
                    holder.registerProblem((PsiElement)switchBlock, message2, highlighting, new LocalQuickFix[]{fix});
                } else {
                    int length = switchBlock.getFirstChild().getTextLength();
                    holder.registerProblem((PsiElement)switchBlock, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new TextRange(0, length), new LocalQuickFix[]{fix});
                    if (isOnTheFly) {
                        TextRange range = new TextRange(length, switchBlock.getTextLength());
                        holder.registerProblem((PsiElement)switchBlock, message2, ProblemHighlightType.INFORMATION, range, new LocalQuickFix[]{fix});
                    }
                }
            }
        };
    }
}

