/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class CloneCallsConstructorsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        return type2 instanceof PsiArrayType ? InspectionGadgetsBundle.message("clone.instantiates.new.array.problem.descriptor", type2.getPresentableText()) : InspectionGadgetsBundle.message("clone.instantiates.objects.with.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneCallsConstructorVisitor();
    }

    private static class CloneCallsConstructorVisitor
    extends BaseInspectionVisitor {
        private CloneCallsConstructorVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!CloneUtils.isClone(method) || method.hasModifierProperty("final")) {
                return;
            }
            final PsiClass aClass = method.getContainingClass();
            if (aClass == null || aClass.hasModifierProperty("final")) {
                return;
            }
            method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                    PsiClass clonedClass;
                    super.visitNewExpression(newExpression);
                    if (newExpression.getAnonymousClass() != null) {
                        return;
                    }
                    if (ParenthesesUtils.getParentSkipParentheses((PsiElement)newExpression) instanceof PsiThrowStatement) {
                        return;
                    }
                    PsiType type2 = newExpression.getType();
                    if (type2 instanceof PsiClassType && (clonedClass = ((PsiClassType)type2).resolve()) != aClass && !InheritanceUtil.isInheritor((PsiClass)clonedClass, (String)"java.lang.Cloneable")) {
                        return;
                    }
                    this.registerNewExpressionError(newExpression, new Object[]{type2});
                }
            });
        }
    }
}

