/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ClassNestingDepthInspection
extends ClassMetricInspection {
    private static final int CLASS_NESTING_LIMIT = 1;

    @NotNull
    public String getID() {
        return "InnerClassTooDeeplyNested";
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("inner.class.too.deeply.nested.nesting.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer nestingLevel = (Integer)infos[0];
        return InspectionGadgetsBundle.message("inner.class.too.deeply.nested.problem.descriptor", nestingLevel);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNestingLevel();
    }

    private class ClassNestingLevel
    extends BaseInspectionVisitor {
        private ClassNestingLevel() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            int nestingLevel = this.getNestingLevel(aClass);
            if (nestingLevel <= ClassNestingDepthInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, nestingLevel);
        }

        private int getNestingLevel(PsiClass aClass) {
            int nestingLevel = 0;
            for (PsiElement ancestor = aClass.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                if (!(ancestor instanceof PsiClass)) continue;
                ++nestingLevel;
            }
            return nestingLevel;
        }
    }
}

