/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PublicConstructorInNonPublicClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        return InspectionGadgetsBundle.message("public.constructor.in.non.public.class.problem.descriptor", method.getName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorInNonPublicClassVisitor();
    }

    @Override
    public InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiMethod constructor = (PsiMethod)infos[0];
        PsiClass aClass = constructor.getContainingClass();
        if (aClass != null && aClass.hasModifierProperty("private")) {
            fixes.add(new SetConstructorModifierFix("private"));
        }
        fixes.add(new RemoveModifierFix("public"));
        return fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    private static class PublicConstructorInNonPublicClassVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorInNonPublicClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            if (!method.isConstructor()) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isRecord() && PsiUtil.getLanguageLevel((PsiElement)containingClass) == LanguageLevel.JDK_14_PREVIEW && (JavaPsiRecordUtil.isCompactConstructor(method) || JavaPsiRecordUtil.isExplicitCanonicalConstructor(method))) {
                return;
            }
            if (containingClass.hasModifierProperty("public") || containingClass.hasModifierProperty("protected")) {
                return;
            }
            if (SerializationUtils.isExternalizable(containingClass) && (parameterList = method.getParameterList()).isEmpty()) {
                return;
            }
            this.registerModifierError("public", (PsiModifierListOwner)method, method);
        }
    }

    private static class SetConstructorModifierFix
    extends InspectionGadgetsFix {
        @PsiModifier.ModifierConstant
        private final String modifier;

        SetConstructorModifierFix(@PsiModifier.ModifierConstant String modifier) {
            this.modifier = modifier;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("set.constructor.modifier.fix.family.name", new Object[0]);
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("public.constructor.in.non.public.class.quickfix", this.modifier);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)element.getParent();
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty(this.modifier, true);
        }
    }
}

