/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveClassFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InnerClassOnInterfaceInspection
extends BaseInspection {
    public boolean m_ignoreInnerInterfaces = false;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inner.class.on.interface.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInnerInterfaces");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveClassFix();
    }

    @NotNull
    public String getID() {
        return "InnerClassOfInterface";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass parentInterface = (PsiClass)infos[0];
        String interfaceName = parentInterface.getName();
        return InspectionGadgetsBundle.message("inner.class.on.interface.problem.descriptor", interfaceName);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassOnInterfaceVisitor();
    }

    private class InnerClassOnInterfaceVisitor
    extends BaseInspectionVisitor {
        private InnerClassOnInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass[] innerClasses;
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (!this.isInnerClass(innerClass)) continue;
                this.registerClassError(innerClass, aClass);
            }
        }

        private boolean isInnerClass(PsiClass innerClass) {
            if (innerClass.isEnum()) {
                return false;
            }
            if (innerClass.isAnnotationType()) {
                return false;
            }
            if (innerClass instanceof PsiTypeParameter || innerClass instanceof PsiAnonymousClass) {
                return false;
            }
            return !innerClass.isInterface() || !InnerClassOnInterfaceInspection.this.m_ignoreInnerInterfaces;
        }
    }
}

