/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassWithOnlyPrivateConstructorsInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeClassFinalFix((PsiClass)infos[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.with.only.private.constructors.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithOnlyPrivateConstructorsVisitor();
    }

    private static class ClassWithOnlyPrivateConstructorsVisitor
    extends BaseInspectionVisitor {
        private ClassWithOnlyPrivateConstructorsVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (aClass.isEnum() || aClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                return;
            }
            PsiClass inheritor = (PsiClass)DirectClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)new LocalSearchScope((PsiElement)aClass.getContainingFile())).findFirst();
            if (inheritor != null) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

