/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class TextLabelInSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("text.label.in.switch.statement.problem.descriptor", infos[0] instanceof PsiSwitchStatement ? 1 : 2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TextLabelInSwitchStatementVisitor();
    }

    private static class TextLabelInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private TextLabelInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            super.visitSwitchStatement(statement);
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            super.visitSwitchExpression(expression2);
            this.visitSwitchBlock((PsiSwitchBlock)expression2);
        }

        private void visitSwitchBlock(PsiSwitchBlock block) {
            PsiCodeBlock body2 = block.getBody();
            if (body2 == null) {
                return;
            }
            for (PsiStatement statement : body2.getStatements()) {
                if (!(statement instanceof PsiLabeledStatement)) continue;
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                this.registerError((PsiElement)labeledStatement.getLabelIdentifier(), block);
            }
        }
    }
}

