/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringEqualsCharSequenceInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        return InspectionGadgetsBundle.message("string.equals.char.sequence.problem.descriptor", type2.getPresentableText());
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression expression2 = (PsiReferenceExpression)infos[1];
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2) && !StringEqualsCharSequenceInspection.isStringEqualsCall(expression2)) {
            return null;
        }
        return new StringEqualsCharSequenceFix();
    }

    private static boolean isStringEqualsCall(PsiReferenceExpression expression2) {
        if (!"equals".equals(expression2.getReferenceName())) {
            return false;
        }
        PsiElement target = expression2.resolve();
        if (!(target instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)target;
        PsiClass aClass = method.getContainingClass();
        return aClass != null && "java.lang.String".equals(aClass.getQualifiedName());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsCharSequenceVisitor();
    }

    private static class StringEqualsCharSequenceVisitor
    extends BaseEqualsVisitor {
        private StringEqualsCharSequenceVisitor() {
        }

        @Override
        void checkTypes(@NotNull PsiReferenceExpression expression2, @NotNull PsiType leftType, @NotNull PsiType rightType) {
            if (!leftType.equalsToText("java.lang.String")) {
                return;
            }
            if (rightType.equalsToText("java.lang.String") || !InheritanceUtil.isInheritor((PsiType)rightType, (String)"java.lang.CharSequence")) {
                return;
            }
            PsiElement name2 = expression2.getReferenceNameElement();
            assert (name2 != null);
            this.registerError(name2, rightType, expression2);
        }
    }

    private static class StringEqualsCharSequenceFix
    extends InspectionGadgetsFix {
        private StringEqualsCharSequenceFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"contentEquals()"});
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)project).createIdentifier("contentEquals");
            element.replace((PsiElement)identifier);
        }
    }
}

