/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortedCollectionWithNonComparableKeysInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> COLLECTIONS = ContainerUtil.immutableSet((Object[])new String[]{"java.util.TreeSet", "java.util.TreeMap", "java.util.concurrent.ConcurrentSkipListSet", "java.util.concurrent.ConcurrentSkipListMap"});
    public boolean IGNORE_TYPE_PARAMETERS;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"inspection.sorted.collection.with.non.comparable.keys.option.type.parameters", (Object[])new Object[0]), (InspectionProfileEntry)this, "IGNORE_TYPE_PARAMETERS");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                if (expression2.getAnonymousClass() != null || expression2.isArrayCreation() || expression2.getArgumentList() == null || !expression2.getArgumentList().isEmpty()) {
                    return;
                }
                PsiJavaCodeReferenceElement reference = expression2.getClassReference();
                if (reference == null) {
                    return;
                }
                String qualifiedName = reference.getQualifiedName();
                if (!COLLECTIONS.contains(qualifiedName)) {
                    return;
                }
                PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)expression2.getType(), PsiClassType.class);
                if (type2 == null || type2.isRaw()) {
                    return;
                }
                PsiType elementType = (PsiType)ArrayUtil.getFirstElement((Object[])type2.getParameters());
                if (elementType == null || TypeUtils.isJavaLangObject(elementType)) {
                    return;
                }
                SetInspectionOptionFix fix = null;
                if (elementType instanceof PsiClassType && ((PsiClassType)elementType).resolve() instanceof PsiTypeParameter) {
                    if (SortedCollectionWithNonComparableKeysInspection.this.IGNORE_TYPE_PARAMETERS) {
                        return;
                    }
                    String message2 = JavaBundle.message((String)"inspection.sorted.collection.with.non.comparable.keys.option.type.parameters", (Object[])new Object[0]);
                    fix = new SetInspectionOptionFix((LocalInspectionTool)SortedCollectionWithNonComparableKeysInspection.this, "IGNORE_TYPE_PARAMETERS", message2, true);
                }
                if (InheritanceUtil.isInheritor((PsiType)elementType, (String)"java.lang.Comparable")) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, JavaBundle.message((String)"inspection.sorted.collection.with.non.comparable.keys.message", (Object[])new Object[0]), new LocalQuickFix[]{fix});
            }
        };
    }
}

