/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertWithSideEffectsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("assert.with.side.effects.problem.descriptor", infos[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertWithSideEffectsVisitor();
    }

    @Nullable
    private static String getCallSideEffectDescription(PsiMethodCallExpression call) {
        PsiExpression expression2;
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        if (JavaMethodContractUtil.isPure(method)) {
            return null;
        }
        MutationSignature signature = MutationSignature.fromMethod(method);
        if (signature.mutatesAnything() && (expression2 = (PsiExpression)signature.mutatedExpressions(call).filter(expr2 -> !ExpressionUtils.isNewObject(expr2)).findFirst().orElse(null)) != null) {
            return "call to '" + method.getName() + "()' mutates '" + expression2.getText() + "'";
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return null;
        }
        MethodSideEffectVisitor visitor2 = new MethodSideEffectVisitor();
        body2.accept((PsiElementVisitor)visitor2);
        String description = visitor2.getMutatedField();
        if (description != null) {
            return "call to '" + method.getName() + "()' mutates field '" + description + "'";
        }
        return null;
    }

    private static class MethodSideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private String mutatedField;

        private MethodSideEffectVisitor() {
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            this.checkExpression(expression2.getLExpression());
            super.visitAssignmentExpression(expression2);
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression2.getOperand());
            }
            super.visitUnaryExpression(expression2);
        }

        private void checkExpression(PsiExpression operand2) {
            if (!((operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2)) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiField) {
                this.mutatedField = ((PsiField)target).getName();
                this.stopWalking();
            }
        }

        private String getMutatedField() {
            return this.mutatedField;
        }
    }

    private static class SideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private String sideEffectDescription;

        private SideEffectVisitor() {
        }

        private String getSideEffectDescription() {
            return this.sideEffectDescription;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            this.sideEffectDescription = expression2.getLExpression().getText() + " " + expression2.getOperationSign().getText() + " ...";
            this.stopWalking();
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            this.sideEffectDescription = AssertWithSideEffectsInspection.getCallSideEffectDescription(expression2);
            if (this.sideEffectDescription != null) {
                this.stopWalking();
            }
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.sideEffectDescription = expression2.getText();
                this.stopWalking();
            } else {
                super.visitUnaryExpression(expression2);
            }
        }
    }

    private static class AssertWithSideEffectsVisitor
    extends BaseInspectionVisitor {
        private AssertWithSideEffectsVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            super.visitAssertStatement(statement);
            PsiExpression condition2 = statement.getAssertCondition();
            if (condition2 == null) {
                return;
            }
            SideEffectVisitor visitor2 = new SideEffectVisitor();
            condition2.accept((PsiElementVisitor)visitor2);
            String description = visitor2.getSideEffectDescription();
            if (description == null) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, description);
        }
    }
}

