/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ArrayHashCodeInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("array.hash.code.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiArrayType type2 = (PsiArrayType)infos[0];
        if (type2.getComponentType() instanceof PsiArrayType) {
            return new ArrayHashCodeFix(true);
        }
        return new ArrayHashCodeFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayHashCodeVisitor();
    }

    private static class ArrayHashCodeVisitor
    extends BaseInspectionVisitor {
        private ArrayHashCodeVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"hashCode".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression2, type2);
        }
    }

    private static class ArrayHashCodeFix
    extends InspectionGadgetsFix {
        private final boolean deepHashCode;

        ArrayHashCodeFix(boolean deepHashCode) {
            this.deepHashCode = deepHashCode;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.deepHashCode ? "Arrays.deepHashCode()" : "Arrays.hashCode()"});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("array.hash.code.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            StringBuilder newExpressionText = new StringBuilder();
            if (this.deepHashCode) {
                newExpressionText.append("java.util.Arrays.deepHashCode(");
            } else {
                newExpressionText.append("java.util.Arrays.hashCode(");
            }
            CommentTracker commentTracker = new CommentTracker();
            newExpressionText.append(commentTracker.text((PsiElement)qualifier));
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpressionText.toString(), commentTracker);
        }
    }
}

