/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InstanceofThisInspection
extends BaseInspection {
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0);

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message(infos[0] instanceof PsiInstanceOfExpression ? "instanceof.check.for.this.problem.descriptor" : "instanceof.check.for.this.equality.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofThisVisitor();
    }

    private static class InstanceofThisVisitor
    extends BaseInspectionVisitor {
        private InstanceofThisVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression compared;
            PsiExpression qualifier;
            if (OBJECT_GET_CLASS.test(call) && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null && StreamEx.of(ExpressionUtils.nonStructuralChildren(qualifier)).select(PsiThisExpression.class).anyMatch(thisExpression -> thisExpression.getQualifier() == null) && (compared = ExpressionUtils.getExpressionComparedTo((PsiExpression)call)) instanceof PsiClassObjectAccessExpression) {
                this.registerError((PsiElement)(qualifier.isPhysical() ? qualifier : call), call);
            }
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisValue) {
            super.visitThisExpression(thisValue);
            if (thisValue.getQualifier() != null) {
                return;
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)thisValue, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiConditionalExpression.class, PsiTypeCastExpression.class});
            if (!(parent instanceof PsiInstanceOfExpression)) {
                return;
            }
            this.registerError((PsiElement)thisValue, parent);
        }
    }
}

