/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextAccessor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EditorTextFieldWithBrowseButton
extends ComponentWithBrowseButton<EditorTextField>
implements TextAccessor {
    public EditorTextFieldWithBrowseButton(Project project, boolean isClassAccepted) {
        this(project, isClassAccepted, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
    }

    public EditorTextFieldWithBrowseButton(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker) {
        this(project, isClassAccepted, visibilityChecker, (FileType)JavaFileType.INSTANCE);
    }

    public EditorTextFieldWithBrowseButton(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker, FileType fileType) {
        super((JComponent)EditorTextFieldWithBrowseButton.createEditorTextField(project, isClassAccepted, visibilityChecker, fileType), null);
    }

    private static EditorTextField createEditorTextField(Project project, boolean isClassAccepted, JavaCodeFragment.VisibilityChecker visibilityChecker, FileType fileType) {
        if (project.isDefault()) {
            return new EditorTextField();
        }
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)project).findPackage("");
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        PsiJavaCodeReferenceCodeFragment fragment = factory.createReferenceCodeFragment("", (PsiElement)defaultPackage, true, isClassAccepted);
        fragment.setVisibilityChecker(visibilityChecker);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
        return new EditorTextField(document, project, fileType);
    }

    public void setText(String text2) {
        ((EditorTextField)this.getChildComponent()).setText(StringUtil.notNullize((String)text2));
    }

    @NotNull
    public String getText() {
        return ((EditorTextField)this.getChildComponent()).getText();
    }
}

