/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.ConfigurationsCollector;
import com.intellij.testIntegration.RecentTestsDataKt;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestCollector;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SingleTestInfo;
import com.intellij.testIntegration.SuiteEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/testIntegration/RecentTestsData;", "", "()V", "runConfigurationSuites", "Ljava/util/HashMap;", "", "Lcom/intellij/testIntegration/RunConfigurationEntry;", "Lkotlin/collections/HashMap;", "testsWithoutSuites", "Ljava/util/ArrayList;", "Lcom/intellij/testIntegration/SingleTestInfo;", "Lkotlin/collections/ArrayList;", "addSuite", "", "suite", "Lcom/intellij/testIntegration/SuiteEntry;", "addTest", "test", "Lcom/intellij/testIntegration/SingleTestEntry;", "findRunConfigurationSuite", "url", "runConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getFailedTests", "", "allConfigurations", "", "getTestsToShow", "Lcom/intellij/testIntegration/RecentTestsPopupEntry;", "moveSuiteTestsToSuite", "intellij.java.execution.impl"})
public final class RecentTestsData {
    private final HashMap<String, RunConfigurationEntry> runConfigurationSuites;
    private ArrayList<SingleTestInfo> testsWithoutSuites;

    public final void addSuite(@NotNull SuiteEntry suite) {
        this.moveSuiteTestsToSuite(suite);
        String id = suite.getRunConfiguration().getUniqueID();
        RunConfigurationEntry entry = this.runConfigurationSuites.get(id);
        if (entry != null) {
            entry.addSuite(suite);
        } else {
            RunConfigurationEntry configurationEntry = new RunConfigurationEntry(suite.getRunConfiguration());
            configurationEntry.addSuite(suite);
            this.runConfigurationSuites.put(id, configurationEntry);
        }
    }

    private final void moveSuiteTestsToSuite(SuiteEntry suite) {
        RunnerAndConfigurationSettings suiteConfiguration = suite.getRunConfiguration();
        boolean bl = false;
        ArrayList<SingleTestInfo> filteredTests = new ArrayList<SingleTestInfo>();
        Iterable $this$forEach$iv = this.testsWithoutSuites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleTestInfo it = (SingleTestInfo)element$iv;
            boolean bl2 = false;
            if (RecentTestsDataKt.isMyTest(suite, it.getTest()) && Intrinsics.areEqual((Object)suiteConfiguration.getName(), (Object)it.getRunConfigurationName())) {
                suite.addTest(it.getTest());
                continue;
            }
            filteredTests.add(it);
        }
        this.testsWithoutSuites = filteredTests;
    }

    public final void addTest(@NotNull SingleTestEntry test) {
        SuiteEntry suiteEntry = this.findRunConfigurationSuite(test.getUrl(), test.getRunConfiguration());
        if (suiteEntry != null) {
            suiteEntry.addTest(test);
        } else {
            this.testsWithoutSuites.add(new SingleTestInfo(test, test.getRunConfiguration().getName()));
        }
    }

    private final SuiteEntry findRunConfigurationSuite(String url, RunnerAndConfigurationSettings runConfiguration) {
        RunConfigurationEntry runConfigurationEntry = this.runConfigurationSuites.get(runConfiguration.getUniqueID());
        if (runConfigurationEntry == null) {
            return null;
        }
        RunConfigurationEntry pack = runConfigurationEntry;
        String testName = VirtualFileManager.extractPath((String)url);
        Iterable $this$forEach$iv = pack.getSuites();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SuiteEntry it = (SuiteEntry)element$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)testName, (String)it.getSuiteName(), (boolean)false, (int)2, null)) continue;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RecentTestsPopupEntry> getTestsToShow() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Collection<SingleTestEntry> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv2;
        Object element$iv2;
        Collection<RunConfigurationEntry> allConfigurations = this.runConfigurationSuites.values();
        List<SingleTestEntry> failedTests = this.getFailedTests(allConfigurations);
        ConfigurationsCollector configsCollector = new ConfigurationsCollector();
        Iterable $this$forEach$iv = allConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            RunConfigurationEntry it = (RunConfigurationEntry)element$iv2;
            boolean bl = false;
            it.accept(configsCollector);
        }
        Iterable $this$filter$iv2 = configsCollector.getEntries();
        boolean $i$f$filter22 = false;
        element$iv2 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RecentTestsPopupEntry it = (RecentTestsPopupEntry)element$iv$iv;
            boolean bl = false;
            if (!(!it.getFailed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List passedConfigurations = (List)destination$iv$iv;
        Iterable $i$f$filter22 = this.testsWithoutSuites;
        Collection collection2 = CollectionsKt.plus((Collection)failedTests, (Iterable)passedConfigurations);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SingleTestInfo bl = (SingleTestInfo)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            SingleTestEntry singleTestEntry = it.getTest();
            collection.add(singleTestEntry);
        }
        collection = (List)destination$iv$iv2;
        $this$map$iv = collection;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SingleTestEntry it = (SingleTestEntry)element$iv$iv;
            boolean bl = false;
            if (!it.getFailed()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv2;
        List entriesToShow = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        Iterable $this$sortedByDescending$iv = entriesToShow;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                RecentTestsPopupEntry it = (RecentTestsPopupEntry)b;
                boolean bl2 = false;
                Comparable comparable = it.getRunDate();
                it = (RecentTestsPopupEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Date date = it.getRunDate();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)date);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<SingleTestEntry> getFailedTests(Collection<RunConfigurationEntry> allConfigurations) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        SingleTestCollector testsCollector = new SingleTestCollector();
        Iterable $this$forEach$iv = allConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            RunConfigurationEntry it = (RunConfigurationEntry)element$iv2;
            boolean bl = false;
            it.accept(testsCollector);
        }
        Iterable $this$filter$iv = testsCollector.getTests();
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SingleTestEntry it = (SingleTestEntry)element$iv$iv;
            boolean bl = false;
            if (!it.getFailed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List failedTests = (List)destination$iv$iv;
        return failedTests;
    }

    public RecentTestsData() {
        boolean bl = false;
        this.runConfigurationSuites = new HashMap();
        bl = false;
        this.testsWithoutSuites = new ArrayList();
    }
}

