/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.filters.AnnotationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.BlockFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ClassFilter;
import com.intellij.structuralsearch.impl.matcher.filters.CommentFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ConstantFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DeclarationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ExpressionFilter;
import com.intellij.structuralsearch.impl.matcher.filters.JavaDocFilter;
import com.intellij.structuralsearch.impl.matcher.filters.MethodFilter;
import com.intellij.structuralsearch.impl.matcher.filters.StatementFilter;
import com.intellij.structuralsearch.impl.matcher.filters.SymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeParameterFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypedSymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.AnnotationHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DeclarationStatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DocDataHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.ExpressionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.StatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SymbolHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TypedSymbolHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompilingVisitor
extends JavaRecursiveElementWalkingVisitor {
    final GlobalCompilingVisitor myCompilingVisitor;
    @NonNls
    private static final Pattern COMMENT_PATTERN = Pattern.compile("__\\$_\\w+");
    static final Set<String> excludedKeywords = ContainerUtil.newHashSet((Object[])new String[]{"class", "interface", "enum", "throws", "extends", "implements"});

    public JavaCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement[] topLevelElements) {
        JavaWordOptimizer optimizer = new JavaWordOptimizer();
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        for (PsiElement element : topLevelElements) {
            element.accept((PsiElementVisitor)this);
            element.accept((PsiElementVisitor)optimizer);
            pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    public void visitDocTag(PsiDocTag psiDocTag) {
        super.visitDocTag(psiDocTag);
        DocValuesIterator nodes = new DocValuesIterator(psiDocTag.getFirstChild());
        while (nodes.hasNext()) {
            this.myCompilingVisitor.setHandler(nodes.current(), (MatchingHandler)new DocDataHandler());
            nodes.advance();
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        super.visitComment(comment);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        GlobalCompilingVisitor.setFilter((MatchingHandler)pattern.getHandler((PsiElement)comment), (NodeFilter)CommentFilter.getInstance());
        String commentText = JavaMatchUtil.getCommentText(comment).trim();
        if (COMMENT_PATTERN.matcher(commentText).matches()) {
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler(commentText);
            if (handler == null) {
                throw new MalformedPatternException();
            }
            comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            RegExpPredicate predicate = handler.findRegExpPredicate();
            if (GlobalCompilingVisitor.isSuitablePredicate((RegExpPredicate)predicate, (SubstitutionHandler)handler)) {
                this.myCompilingVisitor.processTokenizedName(predicate.getRegExp(), true, GlobalCompilingVisitor.OccurenceKind.COMMENT);
            }
        } else if (!commentText.isEmpty()) {
            if (this.myCompilingVisitor.hasFragments(commentText)) {
                MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(comment instanceof PsiDocComment ? comment.getText() : JavaMatchUtil.getCommentText(comment).trim(), GlobalCompilingVisitor.OccurenceKind.COMMENT);
                if (handler != null) {
                    comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                }
            } else {
                this.myCompilingVisitor.processTokenizedName(commentText, false, GlobalCompilingVisitor.OccurenceKind.COMMENT);
            }
        }
    }

    public void visitExpression(PsiExpression expression2) {
        MatchingHandler handler;
        super.visitExpression(expression2);
        if (!(expression2.getParent() instanceof PsiExpressionStatement) && !(expression2 instanceof PsiParenthesizedExpression) && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)expression2)).getFilter() == null) {
            handler.setFilter(e -> DefaultFilter.accepts((PsiElement)expression2, (PsiElement)(e instanceof PsiExpression ? PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)e)) : e)));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        String text2 = expression2.getText();
        if (StringUtil.isQuotedString((String)text2)) {
            @Nullable MatchingHandler handler = this.myCompilingVisitor.processPatternStringWithFragments(text2, GlobalCompilingVisitor.OccurenceKind.LITERAL);
            if (PsiType.CHAR.equals((Object)expression2.getType()) && (handler instanceof LiteralWithSubstitutionHandler || handler == null && expression2.getValue() == null)) {
                throw new MalformedPatternException("Bad character literal");
            }
            if (handler != null) {
                expression2.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
            }
        } else if (!PsiType.NULL.equals((Object)expression2.getType()) && expression2.getValue() == null) {
            throw new MalformedPatternException("Bad literal");
        }
        super.visitLiteralExpression(expression2);
    }

    public void visitField(PsiField psiField) {
        super.visitField(psiField);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiField);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiField, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperFields(true);
        }
    }

    public void visitMethod(PsiMethod psiMethod) {
        super.visitMethod(psiMethod);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiMethod);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiMethod, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperMethods(true);
        }
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)MethodFilter.getInstance());
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        this.visitElement((PsiElement)reference);
        PsiElement referenceParent = reference.getParent();
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        boolean typedVar = pattern.isRealTypedVar((PsiElement)reference) && reference.getQualifierExpression() == null && !(referenceParent instanceof PsiExpressionStatement);
        MatchingHandler handler = pattern.getHandler((PsiElement)reference);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)ExpressionFilter.getInstance());
        String referencedName = reference.getReferenceName();
        if (!typedVar && !(handler instanceof SubstitutionHandler)) {
            PsiElement resolve2 = reference.resolve();
            PsiElement referenceQualifier = reference.getQualifier();
            if (resolve2 instanceof PsiClass || resolve2 == null && (referencedName != null && Character.isUpperCase(referencedName.charAt(0)) || referenceQualifier == null)) {
                PsiExpression qualifier;
                boolean hasNoNestedSubstitutionHandlers = false;
                PsiReferenceExpression currentReference = reference;
                while ((qualifier = currentReference.getQualifierExpression()) != null) {
                    if (!(qualifier instanceof PsiReferenceExpression) || pattern.getHandler((PsiElement)qualifier) instanceof SubstitutionHandler) {
                        hasNoNestedSubstitutionHandlers = true;
                        break;
                    }
                    currentReference = (PsiReferenceExpression)qualifier;
                }
                if (!hasNoNestedSubstitutionHandlers && PsiTreeUtil.getChildOfType((PsiElement)reference, PsiAnnotation.class) == null) {
                    String fqName;
                    String text2 = resolve2 != null ? ((fqName = ((PsiClass)resolve2).getQualifiedName()) == null ? reference.getText() : fqName) : reference.getText();
                    this.createAndSetSubstitutionHandlerFromReference((PsiElement)reference, text2, referenceParent instanceof PsiReferenceExpression);
                }
            }
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        super.visitBlockStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, BlockFilter.getInstance());
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, e -> e instanceof PsiSwitchBlock);
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        super.visitSwitchLabelStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, e -> e instanceof PsiSwitchLabelStatementBase);
    }

    public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
        super.visitSwitchLabeledRuleStatement(statement);
        this.myCompilingVisitor.setFilterSimple((PsiElement)statement, e -> e instanceof PsiSwitchLabelStatementBase);
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        this.myCompilingVisitor.setFilterSimple((PsiElement)variable, e -> e instanceof PsiVariable);
    }

    public void visitParameter(PsiParameter parameter2) {
        super.visitParameter(parameter2);
        PsiElement parent = parameter2.getParent();
        if (!(parent instanceof PsiCatchSection)) {
            return;
        }
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandlerSimple((PsiElement)parameter2);
        String name2 = "__catch_" + parent.getTextOffset();
        SubstitutionHandler substitutionHandler = handler instanceof SubstitutionHandler ? new SubstitutionHandler(name2, false, ((SubstitutionHandler)handler).getMinOccurs(), ((SubstitutionHandler)handler).getMaxOccurs(), true) : new SubstitutionHandler(name2, false, 1, 1, true);
        pattern.setHandler(parent, (MatchingHandler)substitutionHandler);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement psiDeclarationStatement) {
        super.visitDeclarationStatement(psiDeclarationStatement);
        PsiElement firstChild = psiDeclarationStatement.getFirstChild();
        if (firstChild instanceof PsiTypeElement) {
            PsiTypeElement[] typeParameterElements;
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement reference = ((PsiTypeElement)firstChild).getInnermostComponentReferenceElement();
            if (reference != null && (parameterList = reference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0) {
                this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, (MatchingHandler)new TypedSymbolHandler());
                this.myCompilingVisitor.setFilterSimple((PsiElement)psiDeclarationStatement, TypedSymbolNodeFilter.getInstance());
                for (PsiTypeElement param : typeParameterElements) {
                    if (param.getInnermostComponentReferenceElement() == null || !this.myCompilingVisitor.getContext().getPattern().isRealTypedVar(param.getInnermostComponentReferenceElement().getReferenceNameElement())) continue;
                    this.myCompilingVisitor.setFilterSimple((PsiElement)param, TypeParameterFilter.getInstance());
                }
                return;
            }
        } else if (firstChild instanceof PsiModifierList) {
            PsiModifierList modifierList = (PsiModifierList)firstChild;
            PsiAnnotation[] annotations = modifierList.getAnnotations();
            if (annotations.length != 1) {
                throw new MalformedPatternException();
            }
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!modifierList.hasExplicitModifier(modifier)) continue;
                throw new MalformedPatternException();
            }
            this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, (MatchingHandler)new AnnotationHandler());
            this.myCompilingVisitor.setFilterSimple((PsiElement)psiDeclarationStatement, AnnotationFilter.getInstance());
            return;
        }
        DeclarationStatementHandler handler = new DeclarationStatementHandler();
        this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)psiDeclarationStatement, (MatchingHandler)handler);
        PsiElement previousNonWhiteSpace = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiDeclarationStatement);
        if (previousNonWhiteSpace instanceof PsiComment) {
            handler.setCommentHandler(this.myCompilingVisitor.getContext().getPattern().getHandler(previousNonWhiteSpace));
            this.myCompilingVisitor.getContext().getPattern().setHandler(previousNonWhiteSpace, (MatchingHandler)handler);
        }
        handler.setFilter(DeclarationFilter.getInstance());
    }

    public void visitDocComment(PsiDocComment psiDocComment) {
        super.visitDocComment(psiDocComment);
        this.myCompilingVisitor.setFilterSimple((PsiElement)psiDocComment, JavaDocFilter.getInstance());
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        PsiElement parent = reference.getParent();
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference);
        if (parent != null && parent.getParent() instanceof PsiClass) {
            GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)TypeFilter.getInstance());
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            if (newExpression.getArrayInitializer() != null) {
                GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiJavaCodeReferenceElement || e instanceof PsiKeyword);
            } else {
                GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiJavaCodeReferenceElement);
            }
        }
    }

    public void visitTypeElement(PsiTypeElement type2) {
        super.visitTypeElement(type2);
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)type2);
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, e -> e instanceof PsiTypeElement);
    }

    public void visitClass(PsiClass psiClass) {
        super.visitClass(psiClass);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiClass);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiClass, handler)) {
            ((JavaCompiledPattern)pattern).setRequestsSuperInners(true);
        }
        GlobalCompilingVisitor.setFilter((MatchingHandler)handler, (NodeFilter)ClassFilter.getInstance());
    }

    private void createAndSetSubstitutionHandlerFromReference(PsiElement expr2, String referenceText, boolean classQualifier) {
        SubstitutionHandler substitutionHandler = new SubstitutionHandler("__" + referenceText.replace('.', '_'), false, classQualifier ? 0 : 1, 1, true);
        boolean caseSensitive = this.myCompilingVisitor.getContext().getOptions().isCaseSensitiveMatch();
        substitutionHandler.setPredicate((MatchPredicate)new RegExpPredicate(StructuralSearchUtil.shieldRegExpMetaChars((String)referenceText), caseSensitive, null, false, false));
        this.myCompilingVisitor.getContext().getPattern().setHandler(expr2, (MatchingHandler)substitutionHandler);
    }

    public void visitExpressionStatement(PsiExpressionStatement expressionStatement) {
        MatchingHandler handler;
        super.visitExpressionStatement(expressionStatement);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        PsiElement child = expressionStatement.getLastChild();
        PsiElement parent = expressionStatement.getParent();
        if (!(child instanceof PsiJavaToken) && !(child instanceof PsiComment) && parent instanceof PsiCodeFragment) {
            PsiElement reference = expressionStatement.getFirstChild();
            MatchingHandler referenceHandler = pattern.getHandler(reference);
            if (referenceHandler instanceof SubstitutionHandler && reference instanceof PsiReferenceExpression) {
                pattern.setHandler((PsiElement)expressionStatement, referenceHandler);
                referenceHandler.setFilter(SymbolNodeFilter.getInstance());
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, (MatchingHandler)new SymbolHandler((SubstitutionHandler)referenceHandler));
            } else if (reference instanceof PsiLiteralExpression) {
                ExpressionHandler handler2 = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, (MatchingHandler)handler2);
                handler2.setFilter(ConstantFilter.getInstance());
            } else {
                ExpressionHandler handler3 = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expressionStatement, (MatchingHandler)handler3);
                handler3.setFilter(ExpressionFilter.getInstance());
            }
        } else if (expressionStatement.getExpression() instanceof PsiReferenceExpression && pattern.isRealTypedVar((PsiElement)expressionStatement) && (handler = pattern.getHandler((PsiElement)expressionStatement)) instanceof SubstitutionHandler) {
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            if (parent instanceof PsiForStatement && (((PsiForStatement)parent).getInitialization() == expressionStatement || ((PsiForStatement)parent).getUpdate() == expressionStatement)) {
                substitutionHandler.setFilter(e -> e instanceof PsiExpression || e instanceof PsiExpressionListStatement || e instanceof PsiDeclarationStatement || e instanceof PsiEmptyStatement);
            } else {
                substitutionHandler.setFilter((NodeFilter)new StatementFilter());
                substitutionHandler.setMatchHandler((MatchingHandler)new StatementHandler());
            }
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        for (PsiElement el = block.getFirstChild(); el != null; el = el.getNextSibling()) {
            if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                if (!(el instanceof PsiWhiteSpace)) continue;
                this.myCompilingVisitor.addLexicalNode(el);
                continue;
            }
            el.accept((PsiElementVisitor)this);
        }
    }

    private static boolean needsSupers(PsiElement element, MatchingHandler handler) {
        if (element.getParent() instanceof PsiClass && handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler2 = (SubstitutionHandler)handler;
            return handler2.isStrictSubtype() || handler2.isSubtype();
        }
        return false;
    }

    private class JavaWordOptimizer
    extends JavaRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private JavaWordOptimizer() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String word = reference.getReferenceName();
            if (!this.handleWord(word, GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            if (reference.isQualified() && this.isClassFromJavaLangPackage(reference.resolve())) {
                return;
            }
            super.visitReferenceElement(reference);
        }

        private boolean isClassFromJavaLangPackage(PsiElement target) {
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiFile file = target.getContainingFile();
            if (!(file instanceof PsiJavaFile)) {
                return false;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            return "java.lang".equals(javaFile.getPackageName());
        }

        public void visitMethod(PsiMethod method) {
            if (!this.handleWord(method.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitMethod(method);
        }

        public void visitVariable(PsiVariable variable) {
            if (!this.handleWord(variable.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitCatchSection(PsiCatchSection section) {
            PsiParameter parameter2 = section.getParameter();
            if (parameter2 != null && !this.handleWord(parameter2.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitCatchSection(section);
        }

        public void visitClass(PsiClass aClass) {
            CompileContext context = JavaCompilingVisitor.this.myCompilingVisitor.getContext();
            if (!this.handleWord(aClass.getName(), GlobalCompilingVisitor.OccurenceKind.CODE, context)) {
                return;
            }
            if (aClass.isInterface()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"interface", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            } else if (aClass.isEnum()) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"enum", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            } else {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"interface", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"enum", (boolean)false, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"class", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)context);
            }
            super.visitClass(aClass);
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            PsiType type2 = expression2.getType();
            if ((PsiType.BOOLEAN.equals((Object)type2) || PsiType.NULL.equals((Object)type2)) && !this.handleWord(expression2.getText(), GlobalCompilingVisitor.OccurenceKind.CODE, JavaCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitLiteralExpression(expression2);
        }

        public void visitElement(@NotNull PsiElement element) {
            String keyword;
            super.visitElement(element);
            if (element instanceof PsiMethodReferenceExpression) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"::", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            } else if (element instanceof PsiLambdaExpression) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)"->", (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            } else if (element instanceof PsiKeyword && (!excludedKeywords.contains(keyword = element.getText()) || element.getParent() instanceof PsiExpression)) {
                GlobalCompilingVisitor.addFilesToSearchForGivenWord((String)keyword, (boolean)true, (GlobalCompilingVisitor.OccurenceKind)GlobalCompilingVisitor.OccurenceKind.CODE, (CompileContext)JavaCompilingVisitor.this.myCompilingVisitor.getContext());
            }
        }

        public List<String> getDescendantsOf(String className2, boolean includeSelf, Project project) {
            SmartList result = new SmartList();
            GlobalSearchScope projectAndLibraries = ProjectScope.getAllScope((Project)project);
            PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project).getClassesByName(className2, projectAndLibraries);
            if (classes2.length == 0) {
                result.add((Object)className2);
                return result;
            }
            for (PsiClass aClass : classes2) {
                String name2;
                if (includeSelf && (name2 = aClass.getName()) != null) {
                    result.add((Object)name2);
                }
                ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)projectAndLibraries, (boolean)true).forEach(c -> {
                    String name2 = c.getName();
                    if (name2 != null) {
                        result.add((Object)name2);
                    }
                    return true;
                });
            }
            return result;
        }
    }
}

