/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.execution.filters.ExceptionAnalysisProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.slicer.DfaBasedFilter;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.slicer.StackFilter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaValueFilter
implements SliceValueFilter {
    public static final JavaValueFilter ALLOW_EVERYTHING = new JavaValueFilter(null, null);
    @Nullable
    private final DfaBasedFilter myDfaFilter;
    @Nullable
    private final StackFilter myStackFilter;

    JavaValueFilter(@Nullable DfaBasedFilter filter, @Nullable StackFilter stackFilter) {
        this.myDfaFilter = filter;
        this.myStackFilter = stackFilter;
    }

    JavaValueFilter(@NotNull DfType dfType) {
        this(new DfaBasedFilter(dfType), null);
    }

    public boolean allowed(@NotNull PsiElement element) {
        return !(this.myDfaFilter != null && !this.myDfaFilter.allowed(element) || this.myStackFilter != null && !this.myStackFilter.isAcceptable(element));
    }

    @NotNull
    public JavaValueFilter withStack(List<ExceptionAnalysisProvider.StackLine> lines) {
        return new JavaValueFilter(this.myDfaFilter, StackFilter.from(lines));
    }

    @NotNull
    JavaValueFilter withType(DfType type2) {
        return new JavaValueFilter(new DfaBasedFilter(type2), this.myStackFilter);
    }

    @NotNull
    JavaValueFilter pushFrame() {
        if (this.myStackFilter == null) {
            return this;
        }
        return new JavaValueFilter(this.myDfaFilter, this.myStackFilter.pushFrame());
    }

    @NotNull
    JavaValueFilter popFrame(Project project) {
        if (this.myStackFilter == null) {
            return this;
        }
        return new JavaValueFilter(this.myDfaFilter, this.myStackFilter.popFrame(project));
    }

    @NotNull
    JavaValueFilter dropFrameFilter() {
        if (this.myStackFilter == null) {
            return this;
        }
        return new JavaValueFilter(this.myDfaFilter, null);
    }

    @NotNull
    JavaValueFilter wrap() {
        if (this.myDfaFilter == null) {
            return this;
        }
        return new JavaValueFilter(this.myDfaFilter.wrap(), this.myStackFilter);
    }

    @NotNull
    JavaValueFilter unwrap() {
        if (this.myDfaFilter == null) {
            return this;
        }
        return new JavaValueFilter(this.myDfaFilter.unwrap(), this.myStackFilter);
    }

    @NotNull
    SearchScope correctScope(@NotNull SearchScope scope) {
        return this.myStackFilter == null ? scope : this.myStackFilter.correctScope(scope);
    }

    @NotNull
    @Nls
    public String getPresentationText(@NotNull PsiElement element) {
        return this.myDfaFilter == null ? "" : this.myDfaFilter.getPresentationText(element);
    }

    JavaValueFilter mergeFilter(PsiElement expression2) {
        DfaBasedFilter dfaFilter = this.myDfaFilter == null ? new DfaBasedFilter(DfTypes.TOP) : this.myDfaFilter;
        DfaBasedFilter newFilter = dfaFilter.mergeFilter(expression2);
        return dfaFilter == newFilter ? this : new JavaValueFilter(newFilter, this.myStackFilter);
    }

    DfType getDfType() {
        return this.myDfaFilter == null ? DfTypes.TOP : this.myDfaFilter.getDfType();
    }

    public String toString() {
        return ((this.myDfaFilter == null ? "" : this.myDfaFilter.toString()) + " " + (this.myStackFilter == null ? "" : this.myStackFilter.toString())).trim();
    }

    public boolean requiresAssertionViolation(PsiElement element) {
        return this.myDfaFilter != null && this.myDfaFilter.requiresAssertionViolation(element);
    }

    JavaValueFilter copyStackFrom(SliceValueFilter filter) {
        if (filter instanceof JavaValueFilter && ((JavaValueFilter)filter).myStackFilter != this.myStackFilter) {
            return new JavaValueFilter(this.myDfaFilter, ((JavaValueFilter)filter).myStackFilter);
        }
        return this;
    }
}

