/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.CanItBeNullAction;
import com.intellij.slicer.GroupByLeavesAction;
import com.intellij.slicer.JavaSliceNullnessAnalyzer;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.JavaSlicerAnalysisUtil;
import com.intellij.slicer.JavaValueFilter;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceFilterParseException;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRenderer;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.slicer.SliceUsageTransformer;
import com.intellij.slicer.SliceUtil;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSliceProvider
implements SliceLanguageSupportProvider,
SliceUsageTransformer {
    public static JavaSliceProvider getInstance() {
        return (JavaSliceProvider)LanguageSlicing.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    public SliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        return JavaSliceUsage.createRootUsage(element, params);
    }

    @Nullable
    public Collection<SliceUsage> transform(@NotNull SliceUsage usage) {
        if (usage instanceof JavaSliceUsage) {
            return null;
        }
        PsiElement element = usage.getElement();
        SliceUsage parent = usage.getParent();
        if (usage.params.dataFlowToThis && element instanceof PsiMethod) {
            return SliceUtil.collectMethodReturnValues(parent, parent instanceof JavaSliceUsage ? ((JavaSliceUsage)parent).getSubstitutor() : PsiSubstitutor.EMPTY, (PsiMethod)element);
        }
        if (!(element instanceof PsiExpression) && !(element instanceof PsiVariable)) {
            return null;
        }
        JavaSliceUsage newUsage = parent != null ? new JavaSliceUsage(element, parent, PsiSubstitutor.EMPTY) : this.createRootUsage(element, usage.params);
        return Collections.singletonList(newUsage);
    }

    @Nullable
    public PsiElement getExpressionAtCaret(@NotNull PsiElement atCaret, boolean dataFlowToThis) {
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)atCaret, (Class[])new Class[]{PsiExpression.class, PsiVariable.class, PsiMethod.class});
        if (dataFlowToThis && element instanceof PsiLiteralExpression) {
            return null;
        }
        return element;
    }

    @NotNull
    public PsiElement getElementForDescription(@NotNull PsiElement element) {
        PsiElement elementToSlice;
        if (element instanceof PsiReferenceExpression && (elementToSlice = ((PsiReferenceExpression)element).resolve()) != null) {
            return elementToSlice;
        }
        return element;
    }

    @NotNull
    public SliceUsageCellRendererBase getRenderer() {
        return new SliceUsageCellRenderer();
    }

    public void startAnalyzeLeafValues(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        JavaSlicerAnalysisUtil.createLeafAnalyzer().startAnalyzeValues(structure, finalRunnable);
    }

    public void startAnalyzeNullness(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        new JavaSliceNullnessAnalyzer().startAnalyzeNullness(structure, finalRunnable);
    }

    public void registerExtraPanelActions(@NotNull DefaultActionGroup actionGroup, @NotNull SliceTreeBuilder sliceTreeBuilder) {
        if (sliceTreeBuilder.dataFlowToThis) {
            actionGroup.add((AnAction)new GroupByLeavesAction(sliceTreeBuilder));
            actionGroup.add((AnAction)new CanItBeNullAction(sliceTreeBuilder));
        }
    }

    public boolean supportValueFilters(@NotNull PsiElement expression2) {
        PsiType type2 = JavaSliceProvider.getType(expression2);
        return type2 != null && !PsiType.VOID.equals((Object)type2) && !PsiType.NULL.equals((Object)type2);
    }

    @NotNull
    public SliceValueFilter parseFilter(@NotNull PsiElement expression2, @NotNull String filter) throws SliceFilterParseException {
        PsiExpression constant;
        PsiClass psiClass;
        PsiType type2 = JavaSliceProvider.getType(expression2);
        if (type2 == null) {
            return super.parseFilter(expression2, filter);
        }
        if (filter.equals("null")) {
            if (type2 instanceof PsiPrimitiveType) {
                throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.null.filter.not.applicable.for.primitive.type", (Object[])new Object[]{type2.getPresentableText()}));
            }
            return new JavaValueFilter(DfTypes.NULL);
        }
        if (filter.equals("!null")) {
            if (type2 instanceof PsiPrimitiveType) {
                throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.not.null.filter.not.applicable.for.primitive.type", (Object[])new Object[]{type2.getPresentableText()}));
            }
            return new JavaValueFilter(DfTypes.NOT_NULL_OBJECT);
        }
        RelationType relationType = RelationType.EQ;
        if (PsiType.BYTE.equals((Object)type2) || PsiType.CHAR.equals((Object)type2) || PsiType.SHORT.equals((Object)type2) || PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
            for (RelationType relType : RelationType.values()) {
                if (!filter.startsWith(relType.toString())) continue;
                relationType = relType;
                filter = filter.substring(relType.toString().length()).trim();
                break;
            }
        }
        if ((psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2)) != null && psiClass.isEnum()) {
            PsiField enumConstant = psiClass.findFieldByName(filter, false);
            if (enumConstant instanceof PsiEnumConstant) {
                return new JavaValueFilter(DfTypes.constant(enumConstant, type2));
            }
            throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.enum.constant.not.found", (Object[])new Object[]{filter}));
        }
        try {
            constant = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(filter, expression2);
        }
        catch (IncorrectOperationException ignore) {
            throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.incorrect.expression", (Object[])new Object[]{filter}));
        }
        PsiType constantType = constant.getType();
        if (constantType == null || !type2.isAssignableFrom(constantType)) {
            throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.incorrect.constant.type", (Object[])new Object[]{type2.getPresentableText()}));
        }
        Object o = ExpressionUtils.computeConstantExpression(constant);
        if (o == null) {
            throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.expression.must.evaluate.to.constant", (Object[])new Object[]{filter}));
        }
        if (relationType != RelationType.EQ) {
            if (!(o instanceof Number)) {
                throw new SliceFilterParseException(JavaBundle.message((String)"slice.filter.parse.error.incorrect.constant.expected.number", (Object[])new Object[]{filter}));
            }
            if (PsiType.LONG.equals((Object)type2)) {
                LongRangeSet rangeSet = LongRangeSet.point(((Number)o).longValue()).fromRelation(relationType);
                return new JavaValueFilter(DfTypes.longRange(rangeSet));
            }
            LongRangeSet rangeSet = LongRangeSet.point(((Number)o).intValue()).fromRelation(relationType);
            return new JavaValueFilter(DfTypes.intRangeClamped(rangeSet));
        }
        return new JavaValueFilter(DfTypes.constant(o, type2));
    }

    @Nullable
    private static PsiType getType(@NotNull PsiElement expression2) {
        if (expression2 instanceof PsiExpression) {
            return ((PsiExpression)expression2).getType();
        }
        if (expression2 instanceof PsiVariable) {
            return ((PsiVariable)expression2).getType();
        }
        if (expression2 instanceof PsiMethod) {
            return ((PsiMethod)expression2).getReturnType();
        }
        return null;
    }
}

