/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.util.AbstractVariableData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableData
extends AbstractVariableData {
    public final PsiVariable variable;
    public PsiType type;

    public VariableData(@NotNull PsiVariable var) {
        this.variable = var;
        this.type = VariableData.correctType(var.getType());
    }

    public VariableData(@Nullable PsiVariable var, PsiType type2) {
        this.variable = var;
        if (var != null) {
            if (LambdaUtil.notInferredType((PsiType)type2)) {
                type2 = PsiType.getJavaLangObject((PsiManager)var.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)var.getProject()));
            }
            this.type = VariableData.correctType(SmartTypePointerManager.getInstance((Project)var.getProject()).createSmartTypePointer(type2).getType());
        } else {
            this.type = VariableData.correctType(type2);
        }
    }

    private static PsiType correctType(PsiType varType) {
        if (varType instanceof PsiDisjunctionType) {
            return PsiTypesUtil.getLowestUpperBoundClassType((PsiDisjunctionType)((PsiDisjunctionType)varType));
        }
        return varType;
    }

    @NotNull
    public VariableData substitute(@Nullable PsiVariable var) {
        if (var == null) {
            return this;
        }
        PsiType type2 = this.type instanceof PsiImmediateClassType && ((PsiImmediateClassType)this.type).resolve() instanceof PsiTypeParameter ? JavaPsiFacade.getElementFactory((Project)var.getProject()).createTypeFromText(this.type.getCanonicalText(), (PsiElement)var) : this.type;
        VariableData data = new VariableData(var, type2);
        data.name = this.name;
        data.originalName = this.originalName;
        data.passAsParameter = this.passAsParameter;
        return data;
    }
}

