/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TypeConversionRuleUtil {
    TypeConversionRuleUtil() {
    }

    static List<PsiVariable> getVariablesToMakeFinal(@NotNull PsiExpression expression2) {
        ControlFlow controlFlow;
        try {
            controlFlow = ControlFlowFactory.getInstance(expression2.getProject()).getControlFlow((PsiElement)expression2, new MyControlFlowPolicy((PsiElement)expression2), false, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false);
        if (!writtenVariables.isEmpty()) {
            return null;
        }
        return ContainerUtil.filter(ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize()), v -> !v.hasModifierProperty("final"));
    }

    private static class MyControlFlowPolicy
    implements ControlFlowPolicy {
        private final PsiElement myElement;

        MyControlFlowPolicy(PsiElement element) {
            this.myElement = element;
        }

        @Override
        public PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
            if (refExpr.isQualified()) {
                return null;
            }
            PsiElement refElement = refExpr.resolve();
            if ((refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)this.myElement, (PsiElement)refElement, (boolean)true)) {
                return (PsiVariable)refElement;
            }
            return null;
        }

        @Override
        public boolean isParameterAccepted(@NotNull PsiParameter psiParameter) {
            return true;
        }

        @Override
        public boolean isLocalVariableAccepted(@NotNull PsiLocalVariable psiVariable) {
            return true;
        }
    }
}

