/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.ArrayInitializerAwareConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.AtomicConversionType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class AtomicConstructorConversionDescriptor
extends ArrayInitializerAwareConversionDescriptor {
    @NotNull
    private final AtomicConversionType myType;

    AtomicConstructorConversionDescriptor(String stringToReplace, String replaceByString, PsiExpression expression2, @NotNull AtomicConversionType type2) {
        super(stringToReplace, replaceByString, expression2);
        this.myType = type2;
    }

    @Override
    public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
        PsiNewExpression constructorCall = (PsiNewExpression)super.replace(expression2, evaluator);
        PsiExpression argument = Objects.requireNonNull(constructorCall.getArgumentList()).getExpressions()[0];
        if (this.myType.checkDefaultValue(argument)) {
            argument.delete();
        }
        return constructorCall;
    }
}

