/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiPackageProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance(RenamePsiPackageProcessor.class);

    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PsiPackage;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, final @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        return new RenameDialog(project, element, nameSuggestionContext, editor){

            protected void createNewNameComponent() {
                super.createNewNameComponent();
                String qualifiedName = ((PsiPackage)element).getQualifiedName();
                String packageName = StringUtil.getPackageName((String)qualifiedName);
                this.preselectExtension(packageName.isEmpty() ? 0 : packageName.length() + 1, qualifiedName.length());
            }

            public String[] getSuggestedNames() {
                return new String[]{((PsiPackage)element).getQualifiedName()};
            }

            @NotNull
            public String getNewName() {
                PsiPackage psiPackage = (PsiPackage)element;
                String oldName = psiPackage.getQualifiedName();
                String newName = super.getNewName();
                if (!Comparing.strEqual((String)StringUtil.getPackageName((String)oldName), (String)StringUtil.getPackageName((String)newName))) {
                    return newName;
                }
                return StringUtil.getShortName((String)newName);
            }

            protected void doAction() {
                PsiPackage psiPackage = (PsiPackage)element;
                String oldName = psiPackage.getQualifiedName();
                String newName = super.getNewName();
                if (!Comparing.strEqual((String)StringUtil.getPackageName((String)oldName), (String)StringUtil.getPackageName((String)newName))) {
                    this.invokeRefactoring((BaseRefactoringProcessor)RenamePsiPackageProcessor.createRenameMoveProcessor(newName, psiPackage, this.isSearchInComments(), this.isSearchInNonJavaFiles()));
                } else {
                    super.doAction();
                }
            }
        };
    }

    public static MoveDirectoryWithClassesProcessor createRenameMoveProcessor(final String newName, PsiPackage psiPackage, boolean searchInComments, boolean searchInNonJavaFiles) {
        Project project = psiPackage.getProject();
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiDirectory[] directories = psiPackage.getDirectories();
        return new MoveDirectoryWithClassesProcessor(project, directories, null, searchInComments, searchInNonJavaFiles, false, null){

            @NotNull
            public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                VirtualFile vFile = dir.getVirtualFile();
                VirtualFile sourceRoot = index.getSourceRootForFile(vFile);
                LOG.assertTrue(sourceRoot != null, (Object)vFile.getPath());
                return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getManager().findDirectory(sourceRoot), newName.replaceAll("\\.", "\\/"));
            }

            protected String getTargetName() {
                return newName;
            }

            @NotNull
            protected String getCommandName() {
                return "Rename package";
            }
        };
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiPackage psiPackage = (PsiPackage)element;
        String shortName = StringUtil.getShortName((String)newName);
        psiPackage.handleQualifiedNameChange(PsiUtilCore.getQualifiedNameAfterRename((String)psiPackage.getQualifiedName(), (String)shortName));
        RenameUtil.doRenameGenericNamedElement((PsiElement)element, (String)shortName, (UsageInfo[])usages, (RefactoringElementListener)listener);
    }

    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename((PsiPackage)element, newName, nonJava);
    }

    public static String getPackageQualifiedNameAfterRename(PsiPackage element, String newName, boolean nonJava) {
        if (nonJava) {
            String qName = element.getQualifiedName();
            int index = qName.lastIndexOf(46);
            return index < 0 ? newName : qName.substring(0, index + 1) + newName;
        }
        return newName;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiPackage aPackage = (PsiPackage)element;
        Project project = element.getProject();
        String qualifiedNameAfterRename = RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(aPackage, newName, true);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedNameAfterRename, GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            conflicts.putValue((Object)psiClass, (Object)("Class with qualified name '" + qualifiedNameAfterRename + "'  already exist"));
        }
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        RenamePsiPackageProcessor.preparePackageRenaming((PsiPackage)element, newName, allRenames);
    }

    public static void preparePackageRenaming(PsiPackage psiPackage, String newName, Map<PsiElement, String> allRenames) {
        PsiDirectory[] directories;
        String newDirectoryName = StringUtil.getShortName((String)newName);
        for (PsiDirectory directory : directories = psiPackage.getDirectories()) {
            if (JavaDirectoryService.getInstance().isSourceRoot(directory)) continue;
            allRenames.put((PsiElement)directory, newDirectoryName);
        }
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener listener) {
        Project project = element.getProject();
        PsiPackage psiPackage = (PsiPackage)element;
        String newQualifiedName = PsiUtilCore.getQualifiedNameAfterRename((String)psiPackage.getQualifiedName(), (String)newName);
        return () -> {
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(newQualifiedName);
            if (aPackage == null) {
                return;
            }
            listener.elementRenamed((PsiElement)aPackage);
        };
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renamePackage";
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
    }
}

