/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanPropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        return false;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        return this.getProperty(dataContext) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        this.performInvoke(editor, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        this.performInvoke(null, dataContext);
    }

    private void performInvoke(@Nullable Editor editor, DataContext dataContext) {
        BeanProperty property = this.getProperty(dataContext);
        assert (property != null);
        PsiNamedElement element = property.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            assert (newName != null);
            BeanPropertyRenameHandler.doRename(property, newName, editor, false, false);
            return;
        }
        if (PsiElementRenameHandler.canRename((Project)element.getProject(), (Editor)editor, (PsiElement)element)) {
            new PropertyRenameDialog(property, editor).show();
        }
    }

    public static void doRename(@NotNull BeanProperty property, String newName, @Nullable Editor editor, boolean searchInComments, boolean isPreview) {
        PsiMethod getter;
        PsiElement getterSubstitutor;
        PsiNamedElement psiElement = property.getPsiElement();
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), (PsiElement)psiElement, newName, searchInComments, false);
        rename.setPreviewUsages(isPreview);
        PsiMethod setter = property.getSetter();
        PsiElement setterSubstitutor = BeanPropertyRenameHandler.substituteElementToRename((PsiElement)setter, editor);
        if (setterSubstitutor != null) {
            JavaCodeStyleManager manager;
            String suggestedParameterName;
            if (setterSubstitutor == setter) {
                rename.addElement(setterSubstitutor, PropertyUtilBase.suggestSetterName((String)newName));
            } else {
                rename.addElement(setterSubstitutor, newName);
            }
            PsiParameter[] setterParameters = setter.getParameterList().getParameters();
            if (setterParameters.length == 1 && (suggestedParameterName = (manager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject())).propertyNameToVariableName(property.getName(), VariableKind.PARAMETER)).equals(setterParameters[0].getName())) {
                rename.addElement((PsiElement)setterParameters[0], manager.propertyNameToVariableName(newName, VariableKind.PARAMETER));
            }
        }
        if ((getterSubstitutor = BeanPropertyRenameHandler.substituteElementToRename((PsiElement)(getter = property.getGetter()), editor)) != null) {
            if (getterSubstitutor == getter) {
                rename.addElement(getterSubstitutor, PropertyUtilBase.suggestGetterName((String)newName, (PsiType)getter.getReturnType()));
            } else {
                rename.addElement(getterSubstitutor, newName);
            }
        }
        rename.run();
    }

    @Contract(value="null, _ -> null")
    private static PsiElement substituteElementToRename(@Nullable PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            return null;
        }
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement((PsiElement)element);
        PsiElement substituted = processor2.substituteElementToRename(element, editor);
        if (substituted == null || !PsiElementRenameHandler.canRename((Project)element.getProject(), (Editor)editor, (PsiElement)substituted)) {
            return null;
        }
        return substituted;
    }

    @Nullable
    protected abstract BeanProperty getProperty(DataContext var1);

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final BeanProperty myProperty;
        private final Editor myEditor;

        protected PropertyRenameDialog(BeanProperty property, Editor editor) {
            super(property.getMethod().getProject(), (PsiElement)property.getPsiElement(), null, editor);
            this.myEditor = editor;
            this.myProperty = property;
        }

        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            BeanPropertyRenameHandler.doRename(this.myProperty, newName, this.myEditor, searchInComments, this.isPreviewUsages());
            this.close(0);
        }
    }
}

