/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.changeSignature.inCallers.JavaMethodNode;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeStaticUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class MakeStaticJavaCallerChooser
extends JavaCallerChooser {
    private final Project myProject;

    MakeStaticJavaCallerChooser(PsiMethod method, Project project, Consumer<Set<PsiMethod>> consumer) {
        super(method, project, JavaRefactoringBundle.message((String)"make.static.methods.to.propagate.dialog.title", (Object[])new Object[0]), (Tree)null, (Consumer<? super Set<PsiMethod>>)consumer);
        this.myProject = project;
    }

    static PsiMethod isTheLastClassRef(PsiElement element, PsiMethod member) {
        PsiClass containingClass;
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (!(containingMethod == null || containingMethod.hasModifierProperty("static") || containingMethod.isConstructor() || containingMethod.findDeepestSuperMethods().length != 0 || containingMethod.equals(member) || OverridingMethodsSearch.search((PsiMethod)containingMethod).findFirst() != null || (containingClass = containingMethod.getContainingClass()) == null || !ClassUtil.isTopLevelClass((PsiClass)containingClass) && !containingClass.hasModifierProperty("static"))) {
            InternalUsageInfo[] refsInMember;
            for (InternalUsageInfo info : refsInMember = MakeStaticUtil.findClassRefsInMember((PsiTypeParameterListOwner)containingMethod, true)) {
                PsiElement referencedElement = info.getReferencedElement();
                if (member.equals(referencedElement) || containingMethod.equals(referencedElement)) continue;
                return null;
            }
            return containingMethod;
        }
        return null;
    }

    protected abstract ArrayList<UsageInfo> getTopLevelItems();

    protected JavaMethodNode createTreeNodeFor(PsiMethod nodeMethod, HashSet<PsiMethod> called, Runnable cancelCallback) {
        MakeStaticJavaMethodNode node = new MakeStaticJavaMethodNode(nodeMethod, called, cancelCallback, nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (((PsiMethod)this.getTopMember()).equals(nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    private class MakeStaticJavaMethodNode
    extends JavaMethodNode {
        MakeStaticJavaMethodNode(PsiMethod currentMethod, HashSet<PsiMethod> called, Runnable cancelCallback, Project project) {
            super(currentMethod, (Set<PsiMethod>)called, project, cancelCallback);
        }

        @Override
        protected List<PsiMethod> computeCallers() {
            if (((PsiMethod)MakeStaticJavaCallerChooser.this.getTopMember()).equals(this.getMember())) {
                ArrayList<UsageInfo> items = MakeStaticJavaCallerChooser.this.getTopLevelItems();
                return ContainerUtil.map(items, info -> (PsiMethod)info.getElement());
            }
            return super.computeCallers();
        }

        @Override
        protected MemberNodeBase<PsiMethod> createNode(PsiMethod caller, HashSet<PsiMethod> called) {
            return new MakeStaticJavaMethodNode(caller, called, this.myCancelCallback, this.myProject);
        }

        protected Condition<PsiMethod> getFilter() {
            return method -> !((PsiMethod)this.myMethod).equals(method) && MakeStaticJavaCallerChooser.isTheLastClassRef((PsiElement)method, (PsiMethod)this.myMethod) != null;
        }
    }
}

